/*-------------------------------------------------------------------
Fichier     : upscom.e
Objet       : En-tete du module Up ! Component Object Module.

Module      : Up ! Component Object Module
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsCom)
/*****************************/
#define PasseModuleUpsCom 1

#include <upscom_nt.e>

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
/* Codification de l'objet natif.                               */
/****************************************************************/
enum EnuUpsComObjetCom
   {
   OD_ObjetCom=1,
      /* Objet implementant IUnknown. */
   OD_ObjetC=2
      /* Objet correspondant a une structure ou une union C. */
   };

/*******************************************************************/
typedef struct typupscommachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! Component Object    */
/* Module.                                                         */ 
/*******************************************************************/
{
TypUpsComBStr UpsVmAPI (*Char2BStr)(TypUpsVmSession *Session, TypUpsComBStr Buffer, TypUpsVmLong TailleBuffer, TypUpsVmUnicode *Chaine);
   /* Objet : Cree une chaine au format BStr a partir d'une chaine au format TypUpsVmUnicode. */
TypUpsVmUnicode UpsVmAPI *(*BStr2Char)(TypUpsVmSession *Session, TypUpsVmUnicode *Buffer, TypUpsVmLong TailleBuffer, TypUpsComBStr Chaine);
   /* Objet : Cree une chaine au format TypUpsVmUnicode a partir d'une chaine au format TypUpsVmUnicode. */
/*--------------------------------------------------------------*/
/* Identifiant d'interfaces standard. 							       */
/*--------------------------------------------------------------*/
TypUpsComRefIId UpsVmAPI (*GUID_NULL)(TypUpsVmVoid);
   /* Objet : GUID_NULL(). */
TypUpsComRefIId UpsVmAPI (*IID_IClassFactory)(TypUpsVmVoid);
   /* Objet : IID_IClassFactory(). */
TypUpsComRefIId UpsVmAPI (*IID_IDispatch)(TypUpsVmVoid);
   /* Objet : IID_IDispatch(). */
TypUpsComRefIId UpsVmAPI (*IID_IErrorInfo)(TypUpsVmVoid);
   /* Objet : IID_IErrorInfo(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersist)(TypUpsVmVoid);
   /* Objet : IID_IPersist(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistFile)(TypUpsVmVoid);
   /* Objet : IID_IPersistFile(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistMemory)(TypUpsVmVoid);
   /* Objet : IID_IPersistMemory(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistStorage)(TypUpsVmVoid);
   /* Objet : IID_IPersistStorage(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistStream)(TypUpsVmVoid);
   /* Objet : IID_IPersistStream(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistStreamInit)(TypUpsVmVoid);
   /* Objet : IID_IPersistStreamInit(). */
TypUpsComRefIId UpsVmAPI (*IID_IProvideClassInfo)(TypUpsVmVoid);
   /* Objet : IID_IProvideClassInfo(). */
TypUpsComRefIId UpsVmAPI (*IID_IProvideClassInfo2)(TypUpsVmVoid);
   /* Objet : IID_IProvideClassInfo2(TypUpsVmVoid). */
TypUpsComRefIId UpsVmAPI (*IID_IStream)(TypUpsVmVoid);
   /* Objet : IID_IStream(). */
TypUpsComRefIId UpsVmAPI (*IID_ITypeInfo)(TypUpsVmVoid);
   /* Objet : IID_ITypeInfo(). */
TypUpsComRefIId UpsVmAPI (*IID_IUnknown)(TypUpsVmVoid);
   /* Objet : IID_IUnknown(). */
/*--------------------------------------------------------------*/
/* Application Program Interfaces.   							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*AllouerUnTableau)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions,
   TypUpsVmLong BorneMin, TypUpsVmLong BorneMax, enum EnuUpsVmTypeDeDonnee TypeObjetUps);
   /* Objet : Allocation d'un tableau. */
TypUpsVmPointeurDonnees UpsVmAPI (*ClonerObjetC)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmPointeurDonnees ObjetC2);
   /* Objet : Clonage d'un objet C. */
TypUpsVmShort UpsVmAPI (*CoCreateGuid)(TypUpsComIId *Guid);
   /* Objet : CoCreateGuid(). */
TypUpsVmShort UpsVmAPI (*CoCreateInstance)(TypUpsComIId *ClasseId, TypUpsComIId *IId, TypUpsVmPointeurDonnees *Implementation);
   /* Objet : CoCreateInstance(). */
TypUpsVmShort UpsVmAPI (*CoDisconnectObject)(TypUpsVmPointeurDonnees pIUnknown);
   /* Objet : CoDisconnectObject(). */
TypUpsVmShort UpsVmAPI (*CoFileTimeNow)(TypUpsVmDateEtHeure *DateEtHeure);
   /* Objet : CoFileTimeNow(). */
TypUpsVmShort UpsVmAPI (*CoGetClassObject)(TypUpsComRefIId IIdClasse, TypUpsComRefIId IId, TypUpsVmPointeurDonnees *Classe);
   /* Objet : CoGetClassObject(). */
TypUpsVmShort UpsVmAPI (*CoInitializeEx)(TypUpsVmVoid);
   /* Objet : CoInitializeEx(). */
TypUpsVmShort UpsVmAPI (*CoLockObjectExternal)(TypUpsVmPointeurDonnees pIUnknown, TypUpsVmShort Verrouiller);
   /* Objet : CoLockObjectExternal(). */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstruireClassFactory)(TypUpsComRefIId IId, TypUpsComRefIId ClsId, TypUpsVmPointeurDonnees ObjetClasse,
   TypUpsVmUnsignedLong **IdentifiantClassFactory, TypUpsVmPointeurDonnees *AdresseClassFactory);
   /* Objet : Constructeur de ClassFactory. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstruireObjetC)(TypUpsVmSession *Session, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmShort NbDimensions);
   /* Objet : Constructeur d'un objet C. */
TypUpsVmShort UpsVmAPI (*CoRegisterClassObject)(TypUpsComRefIId ClsId, TypUpsVmPointeurDonnees pIUnknown, TypUpsVmShort EstLocal, 
   TypUpsVmUnsignedLong *Identifiant);
   /* Objet : CoRegisterClassObject(). */
TypUpsVmShort UpsVmAPI (*CoResumeClassObjects)(TypUpsVmVoid);
   /* Objet : CoResumeClassObjects(). */
TypUpsVmShort UpsVmAPI (*CoRevokeClassObject)(TypUpsVmUnsignedLong Identifiant);
   /* Objet : CoRevokeClassObject(). */
TypUpsVmShort UpsVmAPI (*CoSuspendClassObjects)(TypUpsVmVoid);
   /* Objet : CoSuspendClassObjects(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CoTaskMemAlloc)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsVmLong Taille);
   /* Objet : CoTaskMemAlloc(). */
TypUpsVmVoid UpsVmAPI (*CoTaskMemFree)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Buffer);
   /* Objet : CoTaskMemFree(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CoTaskMemRealloc)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsVmPointeurDonnees Buffer,
   TypUpsVmLong Taille);
   /* Objet : CoTaskMemRealloc(). */
TypUpsVmVoid UpsVmAPI (*CoUninitialize)(TypUpsVmVoid);
   /* Objet : CoUninitialize(). */
TypUpsVmShort UpsVmAPI (*CreateErrorInfo)(TypUpsVmPointeurDonnees *pICreateErrorInfo);
   /* Objet : CreateErrorInfo(). */
TypUpsVmShort UpsVmAPI (*CreerUnObjet)(TypUpsVmPointeurDonnees This, TypUpsComInformations *Informations);
   /* Objet : Cree un nouvel objet. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerUnStream)(TypUpsVmUnicode **NomFichier, TypUpsVmUnicode **ModeOuverture,
   TypUpsVmPointeurDonnees Descripteur);
   /* Objet : Creation d'un nouveau Stream. */
TypUpsVmVoid UpsVmAPI (*DetruireObjetC)(TypUpsVmSession *Session, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmShort Reallouer);
   /* Objet : Destructeur d'un objet C. */
TypUpsVmVoid UpsVmAPI (*DetruireUnObjet)(TypUpsComInformations *Informations);
   /* Objet : Detruit un objet. */
TypUpsVmVoid UpsVmAPI (*DetruireUnStream)(TypUpsVmPointeurDonnees pIStream);
   /* Objet : Detruit un stream. */
TypUpsVmShort UpsVmAPI (*DispGetIDsOfNames)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees pITypeInfo, TypUpsVmUnicode **TableNoms, 
   TypUpsVmShort TailleTable, TypUpsVmLong *TableIdentifiants);
   /* Objet : DispGetIDsOfNames(). */
TypUpsVmShort UpsVmAPI (*DispInvoke)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees pITypeInfo, TypUpsVmLong Identifiant, TypUpsVmLong Options, 
   TypUpsComDispParams *Parametres, TypUpsVmPointeurDonnees Resultat, TypUpsComExcepInfo *InformationException, 
   TypUpsVmLong *ParametreEnErreur);
   /* Objet : DispInvoke(). */
TypUpsVmShort UpsVmAPI (*DllRegister)(TypUpsVmUnicode *NomBibliotheque, enum EnuUpsComDllRegister *CodeErreur);
   /* Objet : DllRegister. */
TypUpsVmShort UpsVmAPI (*DllUnregister)(TypUpsVmUnicode *NomBibliotheque, enum EnuUpsComDllRegister *CodeErreur);
   /* Objet : DllUnregister. */
TypUpsVmShort UpsVmAPI (*EcrireObjetC)(enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC,
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions);
   /* Objet : Ecriture d'un objet C. */
TypUpsVmShort (*EstUnTableau)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, TypUpsVmShort *EstNul, 
   TypUpsVmLong *BorneMin, TypUpsVmLong *BorneMax, enum EnuUpsComObjetC *TypeObjetElementC, enum EnuUpsVmTypeDeDonnee *TypeObjetElementUps);
   /* Objet : Verifie si l'objet C est un tableau. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetC)(TypUpsVmPointeurDonnees Session, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Exportation d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetC)(TypUpsVmPointeurDonnees Session, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Importation d'un objet C. */
TypUpsVmShort UpsVmAPI (*IsEqualIID)(TypUpsComRefIId RefIId1, TypUpsComRefIId RefIId2);
   /* Objet : IsEqualIID(). */
TypUpsVmLong UpsVmAPI (*LireIdentifiantClassFactory)(TypUpsVmPointeurDonnees pClassFactory);
   /* Objet : Lit l'identifiant de class factory. */
TypUpsVmShort UpsVmAPI (*LireObjetC)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions,
   enum EnuUpsVmTypeDeDonnee *TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet C. */
TypUpsVmShort UpsVmAPI (*LoadTypeLib)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFichier, TypUpsVmPointeurDonnees *pITypeLib);
   /* Objet : LoadTypeLib(). */
TypUpsVmShort UpsVmAPI (*OleLoadFromStream)(TypUpsVmPointeurDonnees pIStream, TypUpsComRefIId RefIID, TypUpsVmPointeurDonnees *Objet);
   /* Objet : OleLoadFromStream(). */
TypUpsVmShort UpsVmAPI (*OleSaveToStream)(TypUpsVmPointeurDonnees pIPersistStream, TypUpsVmPointeurDonnees pIStream);
   /* Objet : OleSaveToStream(). */
TypUpsVmShort UpsVmAPI (*QueryInterface)(TypUpsVmPointeurDonnees pObjetObjet, TypUpsComRefIId RefIId, TypUpsVmPointeurDonnees *pObjet,
   TypUpsComInformations *Informations, TypUpsComRefIId RefIIdObjet);
   /* Objet : Objet::QueryInterface. */
TypUpsVmShort UpsVmAPI (*RegisterActiveObject)(TypUpsVmPointeurDonnees pIUnknown, TypUpsComRefIId RefIID, TypUpsVmUnsignedLong *Identifiant);
   /* Objet : RegisterActiveObject(). */
TypUpsVmShort UpsVmAPI (*RegisterTypeLib)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees pITypeLib, TypUpsVmUnicode *NomFichier, 
   TypUpsVmUnicode *NomFichierAide);
   /* Objet : RegisterTypeLib(). */
TypUpsVmShort UpsVmAPI (*RevokeActiveObject)(TypUpsVmUnsignedLong Identifiant);
   /* Objet : RevokeActiveObject(). */
TypUpsVmShort UpsVmAPI (*SetErrorInfo)(TypUpsVmPointeurDonnees pIErrorInfo);
   /* Objet : SetErrorInfo(). */
TypUpsComSafeArray UpsVmAPI *(*SafeArrayCreate)(TypUpsVmShort TypeDeDonnees, TypUpsVmLong Taille);
   /* Objet : SafeArrayCreate(). */
TypUpsVmVoid UpsVmAPI (*SafeArrayDestroy)(TypUpsComSafeArray *Tableau);
   /* Objet : SafeArrayDestroy(). */
TypUpsVmShort UpsVmAPI (*SafeArrayGetElement)(TypUpsComSafeArray *Tableau, TypUpsVmLong Index, TypUpsComVariant *Element);
   /* Objet : SafeArrayGetElement(). */
TypUpsVmShort UpsVmAPI (*SafeArrayGetUBound)(TypUpsComSafeArray *Tableau, TypUpsVmLong *Taille);
   /* Objet : SafeArrayGetBound(). */
TypUpsVmShort UpsVmAPI (*SafeArrayPutElement)(TypUpsComSafeArray *Tableau, TypUpsVmLong Index, TypUpsComVariant *Element);
   /* Objet : SafeArrayPutElement(). */
TypUpsVmVoid UpsVmAPI (*SetTableMethodesRappel)(TypUpsComNatTableMethodesRappel TableMethodesRappel2);
   /* Objet : Memorise la table de methodes de rappel vers Ups Com. */
TypUpsComBStr UpsVmAPI (*SysAllocString)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsComOleChar *S);
   /* Objet : SysAllocString(). */
TypUpsComBStr UpsVmAPI (*SysAllocStringByteLen)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsVmLong Taille);
   /* Objet : SysAllocStringByteLen(). */
TypUpsVmVoid UpsVmAPI (*SysFreeString)(TypUpsVmSession *Session, TypUpsComBStr S);
   /* Objet : SysFreeString(). */
TypUpsVmShort UpsVmAPI (*UnRegisterTypeLib)(TypUpsComRefIId RefIID, TypUpsVmShort Version, TypUpsVmShort Revision);
   /* Objet : UnRegisterTypeLib(). */  
/*--------------------------------------------------------------*/
/* IClassFactory.                    							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*ClassFactoryCreateInstance)(TypUpsVmPointeurDonnees pIClassFactory, TypUpsComRefIId RefIId, TypUpsVmPointeurDonnees *pObjet);
   /* Objet : IClassFactory::CreateInstance(). */
/*--------------------------------------------------------------*/
/* IDispatch.                       							       */
/*--------------------------------------------------------------*/
TypUpsVmShort (*DispatchInvoke)(TypUpsVmPointeurDonnees pIDispatch, TypUpsVmShort Identifiant, TypUpsVmShort SorteAppel, 
   TypUpsVmPointeurDonnees DispParams, TypUpsVmPointeurDonnees VariantResultat, TypUpsVmUnicode **MotCleErreur, 
   TypUpsVmShort *NumeroParametreEnErreur);
   /* Objet : IDispatch::Invoke. */
/*--------------------------------------------------------------*/
/* ICreateErrorInfo.                 							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*CreateErrorInfoSetDescription)(TypUpsVmPointeurDonnees CreateErrorInfo, TypUpsComBStr Description);
   /* Objet : ICreateErrorInfo::SetDescription(). */
TypUpsVmShort UpsVmAPI (*CreateErrorInfoSetGUID)(TypUpsVmPointeurDonnees CreateErrorInfo, TypUpsComRefIId RefIID);
   /* Objet : ICreateErrorInfo::SetGUID(). */
/*--------------------------------------------------------------*/
/* IStorage.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*StorageCreateStream)(TypUpsVmPointeurDonnees Storage, TypUpsComBStr NomFichier, TypUpsVmPointeurDonnees *Stream);
   /* Objet : IStorage::CreateStream(). */
TypUpsVmShort UpsVmAPI (*StorageOpenStream)(TypUpsVmPointeurDonnees Storage, TypUpsComBStr NomFichier, TypUpsVmPointeurDonnees *Stream);
   /* Objet : IStorage::OpenStream(). */
/*--------------------------------------------------------------*/
/* IStream.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*StreamRead)(TypUpsVmPointeurDonnees Stream, TypUpsVmChar *Buffer, TypUpsVmLong TailleBufferDemandee, 
   TypUpsVmLong *TailleBufferLue);
   /* Objet : IStream::Read(). */
TypUpsVmShort UpsVmAPI (*StreamSeek)(TypUpsVmPointeurDonnees Stream, TypUpsVmLong Deplacement, enum EnuUpsComStreamSeek Origine);
   /* Objet : IStream::Seek(). */
TypUpsVmShort UpsVmAPI (*StreamWrite)(TypUpsVmPointeurDonnees Stream, TypUpsVmChar *Buffer, TypUpsVmLong TailleBufferDemandee, 
   TypUpsVmLong *TailleBufferEcrite);
   /* Objet : IStream::Write(). */
/*--------------------------------------------------------------*/
/* ITypeInfo.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*TypeInfoGetDllEntry)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, 
   TypUpsVmUnicode *NomDll, TypUpsVmLong TailleNomDll, TypUpsVmUnsignedShort *NumeroPointEntree);
   /* Objet : ITypeInfo::GetDllEntry(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetDocumentation)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, TypUpsVmUnicode *NomElement,
   TypUpsVmLong TailleElement, TypUpsVmUnicode *ChaineAide, TypUpsVmLong TailleChaineAide, TypUpsVmUnsignedLong *NumeroAide, TypUpsVmUnicode *FichierAide,
   TypUpsVmLong TailleFichierAide);
   /* Objet : ITypeInfo::GetDocumentation(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetFuncDesc)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, TypUpsComFuncDescription *Description);
   /* Objet : ITypeInfo::GetFuncDesc(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetImplTypeFlags)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort NumeroClasseImplementee, TypUpsVmLong *Flags);
   /* Objet : ITypeInfo::GetImplTypeFlags(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetNames)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, TypUpsVmUnicode **TableNoms, 
   TypUpsVmShort Taille, TypUpsVmShort *NbParametresLus);
   /* Objet : ITypeInfo::GetNames(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetRefTypeInfo)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmLong hreftype, TypUpsVmPointeurDonnees *TypeInfoUtilisateur);
   /* Objet : ITypeInfo::GetRefTypeInfo(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetRefTypeOfImplType)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmLong NumeroClasseImplementee, TypUpsVmLong *ReferenceType);
   /* Objet : ITypeInfo::GetRefTypeOfImplType(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetVarDesc)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, TypUpsComVarDescription *Description);
   /* Objet : ITypeInfo::GetVarDesc(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetTypeAttr)(TypUpsVmPointeurDonnees TypeInfo, TypUpsComTypeAttributs *TypeAttributs);
   /* Objet : ITypeInfo::GetTypeAttr(). */
TypUpsVmVoid UpsVmAPI (*TypeInfoReleaseFuncDesc)(TypUpsVmPointeurDonnees TypeInfo, TypUpsComFuncDescription *Description);
   /* Objet : ITypeInfo::ReleaseFuncDesc(). */
TypUpsVmVoid UpsVmAPI (*TypeInfoReleaseTypeAttr)(TypUpsVmPointeurDonnees TypeInfo, TypUpsComTypeAttributs *TypeAttributs);
   /* Objet : ITypeInfo::ReleaseTypeAttr(). */
TypUpsVmVoid UpsVmAPI (*TypeInfoReleaseVarDesc)(TypUpsVmPointeurDonnees TypeInfo, TypUpsComVarDescription *Description);
   /* Objet : ITypeInfo::ReleaseVarDesc(). */
/*--------------------------------------------------------------*/
/* ITypeLib.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*TypeLibGetDocumentation)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees TypeLib, TypUpsVmShort Numero, TypUpsVmUnicode *NomElement,
   TypUpsVmLong TailleNomElement, TypUpsVmUnicode *ChaineAide, TypUpsVmLong TailleChaineAide, TypUpsVmUnsignedLong *NumeroAide, TypUpsVmUnicode *FichierAide,
   TypUpsVmLong TailleFichierAide);
   /* Objet : ITypeLib::GetDocumentation(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetLibAttr)(TypUpsVmPointeurDonnees TypeLib, TypUpsComLibrairieAttributs *LibrairieAttributs);
   /* Objet : ITypeLib::GetLibAttr(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetTypeInfo)(TypUpsVmPointeurDonnees TypeLib, TypUpsVmShort Numero, TypUpsVmPointeurDonnees *TypeInfo);
   /* Objet : ITypeLib::GetTypeInfo(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetTypeInfoCount)(TypUpsVmPointeurDonnees TypeLib);
   /* Objet : ITypeLib::GetTypeInfoCount(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetTypeInfoOfGuid)(TypUpsVmPointeurDonnees TypeLib, TypUpsComRefIId RefIID, TypUpsVmPointeurDonnees *TypeInfo);
   /* Objet : ITypeLib::GetTypeInfoOfGuid(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetTypeInfoType)(TypUpsVmPointeurDonnees TypeLib, TypUpsVmShort Numero, enum EnuUpsComTypeKind *Sorte);
   /* Objet : ITypeLib::GetTypeInfoType(). */
/*--------------------------------------------------------------*/
/* IUnknown.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*UnknownAddRef)(TypUpsVmPointeurDonnees ObjetObjet);
   /* Objet : IUnknown::AddRef(). */
TypUpsVmShort UpsVmAPI (*UnknownQueryInterface)(TypUpsVmPointeurDonnees ObjetObjet, TypUpsComRefIId RefIId, TypUpsVmPointeurDonnees *Objet);
   /* Objet : IUnknown::QueryInterface. */
TypUpsVmLong UpsVmAPI (*UnknownRelease)(TypUpsVmPointeurDonnees ObjetObjet);
   /* Objet : IUnknown::Release(). */
} *TypUpsComMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsComMachineInterface_1_1_0 TypUpsComMachineInterface;

/****************************************************************/
typedef struct typupscominterfaceimplementee
/* Objet : Implementation generique d'une interface Com.        */
/****************************************************************/
{
enum EnuUpsComObjetCom Sorte;
   /* Sorte de l'objet natif. */
union
   {
   TypUpsVmPointeurDonnees ObjetCom;
      /* Cas OD_ObjetCom. */
   TypUpsVmPointeurDonnees ObjetC;
      /* Cas OD_ObjetC. */
   } Selection;
   /* Selection en fonction de la sorte. */
} TypUpsComInterfaceImplementee;

typedef TypUpsVmPointeurDonnees UpsVmAPI (*TypUpsComCreerUnObjet)(TypUpsVmVoid);
   /* Objet : Creation d'un objet. */

/****************************************************************/
typedef struct typupscomdonnees
/* Objet: Interface des donnees de Ups Com.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
TypUpsVmLong NbObjetsCrees;
   /* Nombre d'objets de crees. */
TypUpsVmShort TraceCom;
   /* Si Vrai, il faut tracer Ups Com. */
TypUpsVmShort EstDisponible;
   /* Si Vrai, le serveur Com est disponible. */
/*--------------------------------------------------------------*/
/* Methodes de rappel vers UpsKrnSD.                            */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*CreerUnObjet)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : Creation d'un objet. Renseigne par UpsKrnSD. */
TypUpsComInformations UpsVmAPI *(*ExtraireInformations)(TypUpsVmPointeurDonnees This);
   /* Objet : Extrait les informations de l'objet. Renseigne par UpsKrnSD. */
} *TypUpsComDonnees;

/****************************************************************/
typedef struct typprmupscom_1_1
/* Objet : Parametre de EnregistrerComposantCom(AccesServeur:   */
/* Caractere);                                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* AccesServeur:Caractere. */
} TypPrmUpsCom_1_1;

/****************************************************************/
typedef struct typprmupscom_2_1
/* Objet : Parametre de SupprimerComposantCom(AccesServeur:     */
/* Caractere);                                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* AccesServeur:Caractere. */
} TypPrmUpsCom_2_1;

/****************************************************************/
typedef struct typupscomtraitements_1_1_0
/* Objet: Interface des traitements de Ups Com.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmVoid UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session, TypPrmUpsCom_1_1 *UpsPrm);
   /* Objet : EnregistrerComposantCom. */
TypUpsVmVoid UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsCom_2_1 *UpsPrm);
   /* Objet : SupprimerComposantCom. */

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : EnregistrerComposantCom. */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : SupprimerComposantCom. */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* CreationObjetComImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* ConversionComImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException3_get)(TypUpsVmSession *Session);
   /* ExecutionComImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException4_get)(TypUpsVmSession *Session);
   /* EnregistrementComposantCom. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsComMachineInterface UpsVmAPI (*LireMachineInterface)(TypUpsVmVoid);
    /* Objet : Lit l'interface avec la machine pour Ups System. */
TypUpsVmShort UpsVmAPI (*ChargerTypeLib)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, TypUpsVmPointeurDonnees *pITypeLib);
   /* Objet : Charge le fichier tbl de UpsKrn SD. */
TypUpsVmShort UpsVmAPI (*ChargerTypeInfo)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, TypUpsVmPointeurDonnees *pITypeLib, 
   TypUpsVmPointeurDonnees *pITypeInfo, TypUpsComRefIId RefIId);
   /* Objet : Charge le fichier tbl de UpsKrn SD. */
TypUpsVmShort UpsVmAPI (*ExposerClasse)(TypUpsVmSession *Session, TypUpsComRefIId RefIID, TypUpsVmPointeurDonnees pIClassFactory, 
   TypUpsVmUnsignedLong *IdentifiantClassFactory);
   /* Objet : Expose un constructeur de classe. */
TypUpsVmShort UpsVmAPI (*ExposerObjet)(TypUpsVmSession *Session, TypUpsComRefIId RefIID, TypUpsVmPointeurDonnees pIUnknown, TypUpsVmUnsignedLong *Identifiant);
   /* Objet : Expose un objet. */
TypUpsVmVoid UpsVmAPI (*NePlusExposerClasse)(TypUpsVmSession *Session, TypUpsVmUnsignedLong IdentifiantClassFactory);
   /* Objet : N'expose plus un constructeur de classe. */
TypUpsVmVoid UpsVmAPI (*NePlusExposerObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees pIUnknown, TypUpsVmUnsignedLong IdentifiantObjet);
   /* Objet : N'expose plus un objet. */
TypUpsVmShort UpsVmAPI (*BaseDeRegistres)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, TypUpsVmShort Charger,
   TypUpsVmPointeurDonnees *pITypeLib, TypUpsComRefIId RefIId);
   /* Objet : Charge ou decharge la reference des classes dans la base de registres. */
TypUpsVmShort UpsVmAPI (*EnvoyerErreurInfo)(TypUpsVmSession *Session, TypUpsComRefIId RefIId, enum EnuUpsComCodeErreur CodeErreur);
   /* Objet : Envoie ErreurInfo suite a une exception. */
TypUpsVmShort UpsVmAPI (*ConstruireObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees *Resultat, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees ObjetType, TypUpsComRefIId RefIId);
   /* Objet : Construit un objet. */
TypUpsVmVoid UpsVmAPI (*ExtraireAdresseObjet)(TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees This);
   /* Objet : Extrait l'objet de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourAdresseObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees This, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Mise a jour de l'objet de l'objet. */
TypUpsComBStr UpsVmAPI (*Char2BStr)(TypUpsVmSession *Session, TypUpsComBStr Buffer, TypUpsVmLong TailleBuffer, TypUpsVmUnicode *Chaine);
   /* Objet : Cree une chaine au format BStr a partir d'une chaine au format TypUpsVmUnicode. */
TypUpsVmUnicode UpsVmAPI *(*BStr2Char)(TypUpsVmSession *Session, TypUpsVmUnicode *Buffer, TypUpsVmLong TailleBuffer, TypUpsComBStr Chaine);
   /* Objet : Cree une chaine au format TypUpsVmUnicode a partir d'une chaine au format TypUpsVmUnicode. */
TypUpsComBStr UpsVmAPI (*Binaire2BStr)(TypUpsVmSession *Session, TypUpsComBStr Buffer, TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type BStr. */
TypUpsComByte UpsVmAPI *(*Binaire2Byte)(TypUpsVmSession *Session, TypUpsComByte *Buffer, TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type byte *. */
TypUpsVmUnsignedChar UpsVmAPI *(*Binaire2UnsignedChar)(TypUpsVmSession *Session, TypUpsVmUnsignedChar *Buffer, TypUpsVmLong TailleBuffer, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type TypUpsVmUnsignedChar *. */
TypUpsComBStr UpsVmAPI (*Caractere2BStr)(TypUpsVmSession *Session, TypUpsComBStr Buffer, TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type BStr. */
TypUpsVmChar UpsVmAPI *(*Caractere2Char)(TypUpsVmSession *Session, TypUpsVmChar *Buffer, TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type TypUpsVmChar *. */
TypUpsComWCharT UpsVmAPI *(*Caractere2WCharT)(TypUpsVmSession *Session, TypUpsComWCharT *Buffer, TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type TypUpsComWCharT *. */
TypUpsVmAdresse UpsVmAPI *(*BStr2Binaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsComBStr Buffer);
   /* Objet : Lit un objet de type BSTR en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*Byte2Binaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsComByte *Buffer, TypUpsVmLong Taille);
   /* Objet : Lit un objet de type byte * en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*UnsignedChar2Binaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Lit un objet de type TypUpsVmUnsignedChar * en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*BStr2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsComBStr Buffer);
   /* Objet : Lit un objet de type BStr en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*Char2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmChar *Buffer);
   /* Objet : Lit un objet de type TypUpsVmChar en un objet de type Caractere. */
TypUpsVmAdresse UpsVmAPI *(*WCharT2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsComWCharT *Buffer);
   /* Objet : Lit un objet de type wchar_t en un objet de type Caractere. */
TypUpsVmDouble UpsVmAPI (*Date2DATE)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Date en un objet de type DATE. */
TypUpsVmAdresse UpsVmAPI *(*DATE2Date)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmDouble Date);
   /* Objet : Lit un objet de type DATE en un objet de type Date. */
TypUpsVmVoid UpsVmAPI (*TracerCom)(TypUpsVmSession *Session, TypUpsVmUnicode *Filtre, TypUpsVmPointeurDonnees P1, TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3, 
   TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Trace une action de Ups Com. */
TypUpsVmVoid UpsVmAPI (*TracerQueryInterface)(TypUpsVmSession *Session, TypUpsVmUnicode *Libelle, TypUpsComRefIId riid);
   /* Objet : Trace un ?::QueryInterface. */
TypUpsVmVoid UpsVmAPI (*TracerCodeErreur)(TypUpsVmSession *Session, enum EnuUpsComCodeErreur CodeErreur);
   /* Objet : Trace un code d'erreur. */
TypUpsVmVoid UpsVmAPI (*DecoderGUID)(TypUpsVmSession *Session, TypUpsVmUnicode *Guid, TypUpsComRefIId RefIID);
   /* Objet : Decode un GUID. */
TypUpsVmUnicode UpsVmAPI *(*FormaterGUID)(TypUpsVmSession *Session, TypUpsVmUnicode *Buffer, TypUpsVmLong TailleBuffer, TypUpsComRefIId riid);
   /* Objet : Formate un GUID. */
TypUpsVmVoid UpsVmAPI (*UtiliserObjetCom)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees This);
   /* Objet : Utilise l'objet issu d'une classe ou d'un interface. */
TypUpsVmVoid UpsVmAPI (*NePlusUtiliserObjetCom)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees This);
   /* Objet : N'utilise plus l'objet issu d'une classe ou d'une interface. */
TypUpsVmShort UpsVmAPI (*CreerObjetAppelInterface)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmPointeurDonnees IdentifiantClasse, TypUpsVmPointeurDonnees Prototype, TypUpsVmPointeurDonnees Objet);
   /* Objet : Cree un objet appel. */
TypUpsVmShort UpsVmAPI (*CreerObjetAppelDirect)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmPointeurDonnees Prototype, TypUpsVmPointeurTraitements Appel);
   /* Objet : Cree un objet appel. */
TypUpsVmShort UpsVmAPI (*ConstruireClassFactory)(TypUpsVmSession *Session, TypUpsComRefIId IId, TypUpsComRefIId ClsId, 
   TypUpsVmPointeurDonnees ObjetClasse, TypUpsVmPointeurDonnees *AdresseClassFactory);
   /* Objet : Constructeur de ClassFactory. */
TypUpsVmVoid UpsVmAPI (*DetruireClassFactory)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees ClassFactory);
   /* Objet : Constructeur de ClassFactory. */
TypUpsVmShort UpsVmAPI (*GetTypeInfoCount)(TypUpsVmUnsignedLong *Compteur);
   /* Objet : Methode standard IDispatch::GetTypeInfoCount. */
TypUpsVmShort UpsVmAPI (*GetTypeInfo)(TypUpsVmPointeurDonnees pIDispatch, TypUpsVmUnsignedLong Comteur, TypUpsVmPointeurDonnees *pITypeInfo);
   /* Objet : Methode standard IDispatch::GetTypeInfo. */
TypUpsVmShort UpsVmAPI (*GetIDsOfNames)(TypUpsVmPointeurDonnees This, TypUpsComBStr *TableNoms, TypUpsVmShort TailleTable, 
   TypUpsVmLong *TableIdentifiants);
   /* Objet : Methode standard IDispatch::GetIDsOfNames. */
TypUpsVmVoid UpsVmAPI (*IncrementerUsageParametres)(TypUpsVmSession *Session, TypUpsComDispParams *Parametres);
   /* Objet : Incremente l'usage des parametres. */
TypUpsVmShort UpsVmAPI (*Invoke)(TypUpsVmPointeurDonnees This, TypUpsVmLong Identifiant, 
   TypUpsVmLong Options, TypUpsComDispParams *Parametres, TypUpsComVariant *Resultat, 
   TypUpsComExcepInfo *InformationException, TypUpsVmLong *ParametreEnErreur);
   /* Objet : Methode standard IDispatch::Invoke. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExtraireObjetCom)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait l'implementation d'un objet. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExtraireObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait l'implementation d'un objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Mise a jour de l'implementation d'un objet. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetCom)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType, 
   TypUpsComRefIId RefCId, TypUpsComRefIId RefIId, TypUpsVmPointeurDonnees *pResultat);
   /* Objet : Cree un objet Com. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Cree un objet C. */
TypUpsVmVoid UpsVmAPI (*DetruireObjetCom)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Detruit un objet Com. */
TypUpsVmVoid UpsVmAPI (*ClonerObjetCom)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Cree un objet Com. */
TypUpsVmVoid UpsVmAPI (*ClonerObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Clone un objet C. */
TypUpsVmAdresse UpsVmAPI *(*ObjetCom2Objet)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees pObjet);
   /* Objet : Cree un objet a partir d'un objet Com. */
TypUpsVmVoid UpsVmAPI (*LibererBStr)(TypUpsVmSession *Session, TypUpsComBStr Chaine);
   /* Objet : Liberer la chaine. */
TypUpsVmVoid UpsVmAPI (*LibererByte)(TypUpsVmSession *Session, TypUpsComByte *Chaine);
   /* Objet : Liberer la chaine. */
TypUpsVmVoid UpsVmAPI (*LibererUnsignedChar)(TypUpsVmSession *Session, TypUpsVmUnsignedChar *Chaine);
   /* Objet : Liberer la chaine. */
TypUpsVmVoid UpsVmAPI (*LibererChar)(TypUpsVmSession *Session, TypUpsVmChar *Chaine);
   /* Objet : Liberer la chaine. */
TypUpsVmVoid UpsVmAPI (*LibererWCharT)(TypUpsVmSession *Session, TypUpsComWCharT *Chaine);
   /* Objet : Liberer la chaine. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetCom)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Objet : Exporte un objet Com. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetCom2)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Objet);
   /* Objet : Exporte un objet Com. */
TypUpsVmVoid UpsVmAPI (*ImporterObjetCom)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsComRefIId RefIId);
   /* Objet : Importe un objet Com. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetCom2)(TypUpsVmSession *Session, TypUpsComRefIId RefIId);
   /* Objet : Importe un objet Com. */
TypUpsVmVoid UpsVmAPI (*ImporterObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Importe un objet C. */
TypUpsVmVoid UpsVmAPI (*ExecuterProcedureOuFonction)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees pObjet, 
   TypUpsVmShort Identifiant, TypUpsVmShort SorteAppel, TypUpsVmPointeurDonnees DispParams, TypUpsVmUnicode *LibelleAppel,
   TypUpsVmPointeurDonnees VariantResultat);
   /* Execution d'une procedure ou d'une fonction. */
TypUpsVmVoid UpsVmAPI (*EnvoyerExceptionStandard)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsComExcepInfo *InformationException);
   /* Objet : Envoie une exception. */
TypUpsVmShort UpsVmAPI (*EnregistrerComposantCom)(TypUpsVmSession *Session, TypUpsVmUnicode *NomBibliotheque, TypUpsVmUnicode *MessageErreur);
   /* Objet : Enregistre le composant Com. */
TypUpsVmShort UpsVmAPI (*SupprimerComposantCom)(TypUpsVmSession *Session, TypUpsVmUnicode *NomBibliotheque, TypUpsVmUnicode *MessageErreur);
   /* Objet : Supprime le composant Com. */
TypUpsVmVoid UpsVmAPI (*EcrireObjetC)(TypUpsVmSession *Session, enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Ecriture d'un objet C. */
TypUpsVmVoid UpsVmAPI (*LireObjetC)(TypUpsVmSession *Session, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet C. */
} *TypUpsComTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsComTraitements_1_1_0 TypUpsComTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsComDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Com. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
