/*-------------------------------------------------------------------
Fichier     : upsvm_nt.e
Objet       : Liste des definitions natives de Up ! Virtual Machine

Module      : Ups Vm
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

---------------------------------------------------------------------*/

/*******************************/
#if !defined(PasseModuleUpsVmNat)
/*******************************/
#define PasseModuleUpsVmNat 1

#include <setjmp.h>

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/*--------------------------------------------------------------*/
/* Definition de la plate-forme materielle.                     */ 
/*--------------------------------------------------------------*/
#define PLATEFORMEINTEL86 1

/******************/
#if defined(MACOS10)
/******************/
#define PLATEFORMEMAC 1
#undef PLATEFORMEOS400
#undef PLATEFORMEOS390
#undef PLATEFORMEOS400
#undef PLATEFORMEUNIX
#undef PLATEFORMEWINDOWS
#undef PLATEFORMEDCOM
#undef PLATEFORMECORBA
#define PLATEFORMEJAVA 1
#define PLATEFORMEGRAPHIQUE 1
#define UpsVmAPI
/****/
#endif
/****/

/****************/
#if defined(OS390)
/****************/
#undef PLATEFORMEMAC
#undef PLATEFORMEOS400
#define PLATEFORMEOS390 1
#undef PLATEFORMEOS400
#undef PLATEFORMEUNIX
#undef PLATEFORMEWINDOWS
#undef PLATEFORMEDCOM
#undef PLATEFORMECORBA
#define PLATEFORMEJAVA 1
#undef PLATEFORMEGRAPHIQUE
#define UpsVmAPI
/****/
#endif
/****/

/****************/
#if defined(OS400)
/****************/
#undef PLATEFORMEMAC
#undef PLATEFORMEOS400
#undef PLATEFORMEOS390
#define PLATEFORMEOS400 1
#undef PLATEFORMEUNIX
#undef PLATEFORMEWINDOWS
#undef PLATEFORMEDCOM
#undef PLATEFORMECORBA
#undef PLATEFORMEJAVA 1
#undef PLATEFORMEGRAPHIQUE
#define UpsVmAPI
/****/
#endif
/****/

/************************************************************************************/
#if defined(AIX43)||defined(DEC40)||defined(DGUX35)||defined(DYNIX40)||defined(HPUX11) \
    ||defined(IRIX64)||defined(LINUX20)||defined(SCO32)||defined(SEQUENT44) \
    ||defined(SINIX40)||defined(SOLARIS27)
/************************************************************************************/
#undef PLATEFORMEMAC
#undef PLATEFORMEOS400
#undef PLATEFORMEOS390
#undef PLATEFORMEOS400
#define PLATEFORMEUNIX 1
#undef PLATEFORMEWINDOWS
#define PLATEFORMEDCOM 1
#define PLATEFORMECORBA 1
#define PLATEFORMEJAVA 1
#undef PLATEFORMEGRAPHIQUE
#define UpsVmAPI
/****/
#endif
/****/

/********************************************************************************/
#if defined(WINDOWS95)||defined(WINDOWSME)||defined(NTINTEL40)||defined(NTALPHA40) \
    ||defined(WINDOWS2000)||defined(WINDOWSXP)
/********************************************************************************/
#undef PLATEFORMEMAC
#undef PLATEFORMEOS400
#undef PLATEFORMEOS390
#undef PLATEFORMEOS400
#undef PLATEFORMEUNIX
#define PLATEFORMEWINDOWS 1
#define PLATEFORMEDCOM 1
#define PLATEFORMECORBA 1
#define PLATEFORMEJAVA 1
#define PLATEFORMEGRAPHIQUE 1
#define UpsVmAPI
/****/
#endif
/****/

/*********************************************************************/
#if defined(NTALPHA40)||defined(DEC32)||defined(DEC40)||defined(IRIX64)
/*********************************************************************/
#define PLATEFORME64DONNEES 1
/***/
#else
/***/
#define PLATEFORME32DONNEES 1
/****/
#endif
/****/

/*************************************************************************************/
#if defined(NTALPHA40)||defined(DEC32)||defined(DEC40)||defined(IRIX64)||defined(OS400)
/*************************************************************************************/
#define PLATEFORME64TRAITEMENTS 1
/***/
#else
/***/
#define PLATEFORME32TRAITEMENTS 1
/****/
#endif
/****/

/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
#pragma warning(disable : 4055 4065 4094 4115 4121 4190 4201 4213 4250 4390 4511 4512 4514 4702 4611)
#pragma warning(push,4)
/*--------------------------------------------------------------*/
/* Definition pour windows.h, winbase.h, etc.                   */ 
/*--------------------------------------------------------------*/
#define WIN32 1
#define _WINDOWS 1
#undef NONAMELESSUNION
/****/
#endif
/****/

/********************/
#if defined(NTINTEL40)
/********************/
#define MISEAUPOINT 1
/***/
#else
/***/
#undef MISEAUPOINT
/****/
#endif
/****/

/****************************************************************/
/* Codification du deplacement du pointeur dans un flux.   		 */
/****************************************************************/
enum EnuUpsVmDeplacement
   {
   TD_Debut=1,
   TD_PositionCourante=2,
   TD_Fin=3
   };

/****************************************************************/
/* Codification de l'action sur les services.             		 */
/****************************************************************/
enum EnuUpsVmActionService
   {
   AS_Demarrer=1,
   AS_Arreter=2,
   AS_Chercher=3
   };

/****************************************************************/
/* Codification l'arret du systeme.                      		 */
/****************************************************************/
enum EnuUpsVmArretSysteme
   {
   AS_FermerSession=1,
   AS_ArreterSysteme=2,
   AS_RelancerSysteme=3
   };

/****************************************************************/
/* Codification des tailles de buffer des flux.		      	    */
/****************************************************************/
enum EnuUpsVmTailleBuffer
   {
   TB_MemoireVolatile=1,
   TB_MemoirePersistant=2,
   TB_Synchrone=3,
   TB_AsynchroneSysteme=4,
   TB_Asynchrone1024=5,
   TB_Asynchrone4096=6,
   TB_Asynchrone16384=7,
   TB_Asynchrone65536=8
   };

/****************************************************************/
/* Sorte d'allocation.                                          */
/****************************************************************/
enum EnuUpsVmSorteAllocation
   {
   SA_Systeme=1,
   SA_Utilisateur=2,
   SA_Tas=3,
   SA_Objet=4
   };

/*******************************************************************/
/* Codification du mode d'ouverture des memoires partagees.        */
/*******************************************************************/
enum EnuUpsVtmMemoirePartagee
   {
   MM_ForcerCreer=1,
   MM_ForcerOuvrir=2,
   MM_ForcerFermer=3,
   MM_Automatique=4
   };

/****************************************************************/
/* Codification des types de donnees.                           */
/****************************************************************/
enum EnuUpsVmTypeDeDonnee
   {
   TD_EnumereCourt=1,
   TD_EnumereLong=2,
   TD_Entier=3,
   TD_Reel=4,
   TD_Binaire=5,
   TD_Caractere=6,
   TD_DateEtHeure=7,
   TD_Objet=8
   };

/****************************************************************/
/* Codification des signaux.                                    */
/****************************************************************/
enum EnuUpsVmSignal
   {
   SI_SigAbrt=1,
   SI_SigAlrm=2,
   SI_SigBreak=3,
   SI_SigBus=4,
   SI_SigCont=5,
   SI_SigFpe=6,
   SI_SigIll=7,
   SI_SigInt=8,
   SI_SigKill=9,
   SI_SigSegv=10,
   SI_SigSys=11,
   SI_SigTerm=12, 
   SI_SigUsr1=13,
   SI_SigUsr2=14
   };

#define CO_TailleNomFichier 256
   /* Taille d'un nom de fichier. */
#define CO_TailleIdf 50
   /* Taille d'un identifiant. */
#define CO_TailleBuffer 256
	/* Taille standard des buffers. */
#define CO_TailleLigneMax 1024
	/* Taille standard des lignes de texte. */
#define CO_NbSortesMemoire 4
   /* Nombre de sorte de memoire. */

/*--------------------------------------------------------------*/
/* Type de donnees natifs de Ups Vm.                            */ 
/*--------------------------------------------------------------*/
typedef char TypUpsVmChar;
typedef unsigned char TypUpsVmUnsignedChar;
/******************************/
#if defined(PLATEFORME64DONNEES)
/******************************/
typedef signed short TypUpsVmShort;
typedef unsigned short TypUpsVmUnsignedShort;
typedef signed int TypUpsVmLong;
typedef unsigned int TypUpsVmUnsignedLong;
/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
typedef signed __int64 TypUpsVmLongLong;
typedef unsigned __int64 TypUpsVmUnsignedLongLong;
/***/
#else
/***/
typedef signed long TypUpsVmLongLong;
typedef unsigned long TypUpsVmUnsignedLongLong;
/****/
#endif
/****/
/***/
#else
/***/
typedef signed short TypUpsVmShort;
typedef unsigned short TypUpsVmUnsignedShort;
typedef signed long TypUpsVmLong;
typedef unsigned long TypUpsVmUnsignedLong;
/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
typedef signed __int64 TypUpsVmLongLong;
typedef unsigned __int64 TypUpsVmUnsignedLongLong;
/***/
#else
/***/
typedef signed long long TypUpsVmLongLong;
typedef unsigned long long TypUpsVmUnsignedLongLong;
/****/
#endif
/****/
/****/
#endif
/****/
typedef float TypUpsVmFloat;
typedef double TypUpsVmDouble;
typedef long double TypUpsVmLongDouble;
typedef TypUpsVmUnsignedShort TypUpsVmUnicode;
#define TypUpsVmVoid void
typedef TypUpsVmVoid *TypUpsVmPointeurDonnees;
typedef TypUpsVmVoid (*TypUpsVmPointeurTraitements)(TypUpsVmVoid);
typedef jmp_buf TypUpsVmRegistres;

#define _T(X) (TypUpsVmUnicode *)(L ## X)
/*--------------------------------------------------------------*/
/* Double inclusion de macro pour que __FILE__ puisse se        */
/* substituer.                                                  */ 
/*--------------------------------------------------------------*/
#define _T2(X) _T(X)
#define __WFILE__ _T2(__FILE__)

/****************/
#if !defined(NULL)
/****************/
#define NULL 0L
/****/
#endif
/****/
#define Inutile(P) {if (P) {;}}

/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
#define DllExport __declspec( dllexport )
/***/
#else
/***/
#define DllExport 
/****/
#endif
/****/

/****************************************************************/
typedef struct typupsvmadresse
/* Objet : Adresse logique de Ups Virtual Machine.              */
/****************************************************************/
{
TypUpsVmPointeurDonnees AdresseBloc;
   /* Adresse du bloc de memoire de l'objet. Pour les entrepots fixes non partages. */
/******************************/
#if defined(PLATEFORME32DONNEES)
/******************************/
TypUpsVmPointeurDonnees TrouAdresseBloc;
   /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
TypUpsVmPointeurDonnees AdresseObjet;
   /* Adresse de l'objet. Pour les entrepots fixes non partages. */
/******************************/
#if defined(PLATEFORME32DONNEES)
/******************************/
TypUpsVmPointeurDonnees TrouAdresseObjet;
   /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
TypUpsVmUnsignedLong NumeroSegment;
   /* Numero du segment. */
TypUpsVmUnsignedShort NumeroNoeud;
   /* Noeud de rattachement du serveur ayant cree l'objet. */
TypUpsVmUnsignedShort NumeroServeur;
   /* Serveur ayant cree l'objet. */
TypUpsVmUnsignedShort Index;
   /* Index de l'objet dans le segment. */
TypUpsVmUnsignedShort NbBlocs;
   /* Nombre de blocs memoire contigue utilise par le segment. */
TypUpsVmUnsignedShort NumeroEntrepot; 
   /* Numero de l'entrepot. */ 
TypUpsVmUnsignedChar Architecture;
   /* Codage bit de l'architecture d'un objet. */  
TypUpsVmUnsignedChar Options;
   /* Codage bit des options d'un objet. */  
} TypUpsVmAdresse;

/*******************************************************************/
typedef struct typupsvmdateetheure
/* Objet : Modelisation des dates et heures.                       */ 
/*******************************************************************/
{
TypUpsVmLong Jour;
   /* Jour. */
TypUpsVmLong Mois;
   /* Mois. */
TypUpsVmLong Annee;
   /* Annee. */
TypUpsVmLong Heures;
   /* Heures. */
TypUpsVmLong Minutes;
   /* Minutes. */
TypUpsVmLong Secondes;
   /* Secondes. */
TypUpsVmLong Milliemes;
   /* Milliemes. */
} TypUpsVmDateEtHeure;

/****************************************************************/
typedef struct typupsvmvaleur
/* Objet : Valeur generique.                                    */
/****************************************************************/
{
enum EnuUpsVmTypeDeDonnee TypeDeDonnees;
   /* Type de la donnee. */
union
   {
   TypUpsVmUnsignedChar EnumereCourt;
      /* Pour un enumere court. */ 
   TypUpsVmUnsignedShort EnumereLong;
      /* Pour un enumere TypUpsVmLong. */ 
   TypUpsVmLong Entier;
      /* Pour un entier. */ 
   TypUpsVmDouble Reel;
      /* Pour un reel. */ 
   TypUpsVmDateEtHeure DateEtHeure;
      /* Pour une date et une heure. */
   TypUpsVmAdresse AdresseObjet;
      /* Pour un objet. */
   TypUpsVmPointeurDonnees Buffer;
      /* Buffer pour un complement si le complement est nul. */
   } Selection;
   /* En fonction du type de la donnee. */
} TypUpsVmValeur;

typedef TypUpsVmShort (*TypUpsVmPrincipalThread)(TypUpsVmPointeurDonnees Parametres);
   /* Fonction principale d'un thread. */
typedef TypUpsVmLong UpsVmAPI (*TypUpsVmLireCleRessourcePartagee)(TypUpsVmChar *NomRessource);
   /* Retrouve une ressource dans upssys.ini. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsVtmGestionnaireSignal)(enum EnuUpsVmSignal NumeroSignal);
   /* Gestionnaire des signaux recu par un thread. Retourne Vrai si le signal a ete traite. */

/*******************************************************************/
typedef struct typupsvtmmachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! Vtm.               */ 
/*******************************************************************/
{
/*--------------------------------------------------------------*/
/* API Posix du systeme d'exploitation.                         */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*StrCmp)(TypUpsVmChar *Chaine1, TypUpsVmChar *Chaine2);
   /* Objet : Reimplementation de strcmp(). */
TypUpsVmShort UpsVmAPI (*WStrCmp)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2);
   /* Objet : Reimplementation de strcmp(). */
TypUpsVmShort UpsVmAPI (*StrICmp)(TypUpsVmChar *Chaine1, TypUpsVmChar *Chaine2);
   /* Objet : Reimplementation de stricmp(). */
TypUpsVmShort UpsVmAPI (*StrNCmp)(TypUpsVmChar *Chaine1, TypUpsVmChar *Chaine2, TypUpsVmShort Taille);
   /* Objet : Reimplementation de strncmp(). */
TypUpsVmShort UpsVmAPI (*WStrNCmp)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2, TypUpsVmShort Taille);
   /* Objet : Reimplementation de strncmp(). */
TypUpsVmShort UpsVmAPI (*StrNICmp)(TypUpsVmChar *Chaine1, TypUpsVmChar *Chaine2, TypUpsVmShort Taille);
   /* Objet : Reimplementation de strnicmp(). */
TypUpsVmVoid UpsVmAPI (*StrCpy)(TypUpsVmChar *Chaine1, TypUpsVmLong TailleChaine1, TypUpsVmChar *Chaine2);
   /* Objet : Reimplementation de strcpy(). */
TypUpsVmVoid UpsVmAPI (*WStrCpy)(TypUpsVmUnicode *Chaine1, TypUpsVmLong TailleChaine1, TypUpsVmUnicode *Chaine2);
   /* Objet : Reimplementation de strcpy(). */
TypUpsVmLong UpsVmAPI (*StrLen)(TypUpsVmChar *Chaine);
   /* Objet : Reimplementation de strlen(). */
TypUpsVmLong UpsVmAPI (*WStrLen)(TypUpsVmUnicode *Chaine);
   /* Objet : Reimplementation de strlen(). */
TypUpsVmVoid UpsVmAPI (*StrCat)(TypUpsVmChar *Chaine1, TypUpsVmLong TailleChaine1, TypUpsVmChar *Chaine2);
   /* Objet : Reimplementation de strcat(). */
TypUpsVmVoid UpsVmAPI (*WStrCat)(TypUpsVmUnicode *Chaine1, TypUpsVmLong TailleChaine1, TypUpsVmUnicode *Chaine2);
   /* Objet : Reimplementation de strcat(). */
TypUpsVmVoid UpsVmAPI (*Sprintf)(TypUpsVmChar *Resultat, TypUpsVmLong TailleChaineResultat, TypUpsVmChar *Filtre, TypUpsVmPointeurDonnees P1, 
   TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3, TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Sprintf simplifie dans le but de faire aisement des concatenations */
   /* dans les procedures d'initialisation. Seul le joker %s est reconnu. */
TypUpsVmShort UpsVmAPI (*Sscanf)(TypUpsVmChar *Chaine, TypUpsVmChar *Filtre, 
   TypUpsVmPointeurDonnees P1, TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3, 
   TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Analyse une chaine. */
TypUpsVmShort UpsVmAPI (*IsAlpha)(TypUpsVmChar C);
   /* Objet : Retourne Vrai si le caractere est un alpha. */
TypUpsVmShort UpsVmAPI (*IsAlphaNum)(TypUpsVmChar C);
   /* Objet : Retourne Vrai si le caractere est un alphanumerique. */
TypUpsVmShort UpsVmAPI (*IsSpace)(TypUpsVmChar C);
   /* Objet : Retourne Vrai si le caractere est un separateur. */
TypUpsVmChar UpsVmAPI (*ToUpper)(TypUpsVmChar C);
   /* Objet : Retourne le caractere en majuscule. */
TypUpsVmChar UpsVmAPI (*ToLower)(TypUpsVmChar C);
   /* Objet : Retourne le caractere en minuscule. */
TypUpsVmShort UpsVmAPI (*IntegerValue)(TypUpsVmChar C);
   /* Objet : Retourne la valeur entiere correspondant au caractere. */
TypUpsVmShort UpsVmAPI (*IsNan)(TypUpsVmDouble D);
   /* Objet : isnan. */
TypUpsVmShort UpsVmAPI (*Finite)(TypUpsVmDouble D);
   /* Objet : finite. */
/*--------------------------------------------------------------*/
/* API non Posix du systeme d'exploitation.                     */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*AjouterExtensionBibliotheque)(TypUpsVmChar *NomBibliotheque);
   /* Objet : Ajoute l'extension du nom de la bibliotheque dynamique. */
TypUpsVmVoid UpsVmAPI (*CalculerBibliothequeNative)(TypUpsVmChar *NomModule, TypUpsVmChar *Bibliotheque);
   /* Objet : Calcule le nom physique de la bibliotheque native. */
TypUpsVmVoid UpsVmAPI (*CalculerBibliotheque)(TypUpsVmChar *NomModule, TypUpsVmChar *Bibliotheque);
   /* Objet : Calcule le nom physique de la bibliotheque. */
TypUpsVmPointeurDonnees UpsVmAPI (*ChargerBibliotheque)(TypUpsVmChar *NomBibliotheque, TypUpsVmChar *MessageErreur, TypUpsVmLong TailleMessageErreur);
   /* Objet : Charge une bibliotheque dynamique. */
TypUpsVmVoid UpsVmAPI (*DechargerBibliotheque)(TypUpsVmPointeurDonnees HandleBibliotheque);
   /* Objet : Decharge une bibliotheque dynamique. */
TypUpsVmPointeurTraitements UpsVmAPI (*LireAPI)(TypUpsVmPointeurDonnees HandleBibliotheque, TypUpsVmChar *NomApi);
   /* Objet : Retrouve une adresse de fonction dans l'instance d'apres son nom. */
TypUpsVmShort UpsVmAPI (*IlExisteFichier)(TypUpsVmChar *NomFichier);
   /* Objet : Teste s'il existe un fichier. */
TypUpsVmPointeurDonnees UpsVmAPI (*AllouerMemoire)(enum EnuUpsVmSorteAllocation, TypUpsVmLong Taille);
   /* Objet : Alloue de la memoire privee au processus. */
TypUpsVmPointeurDonnees UpsVmAPI (*ReallouerMemoire)(enum EnuUpsVmSorteAllocation, TypUpsVmPointeurDonnees Adresse, TypUpsVmLong AncienneTaille, 
   TypUpsVmLong NouvelleTaille);
   /* Objet : Realloue de la memoire privee au processus. */
TypUpsVmVoid UpsVmAPI (*LibererMemoire)(enum EnuUpsVmSorteAllocation, TypUpsVmPointeurDonnees Adresse);
   /* Objet : Effectue une desallocation. */
TypUpsVmVoid UpsVmAPI (*EffacerMemoire)(TypUpsVmPointeurDonnees Adresse, TypUpsVmUnsignedChar Octet, TypUpsVmLong Taille);
   /* Objet : Efface la memoire. */
TypUpsVmVoid UpsVmAPI (*CopierMemoire)(TypUpsVmPointeurDonnees Adresse1, TypUpsVmPointeurDonnees Adresse2, TypUpsVmLong Taille);
   /* Objet : Copie une zone memoire dans une autre. */
TypUpsVmShort UpsVmAPI (*ComparerMemoire)(TypUpsVmPointeurDonnees Adresse1, TypUpsVmPointeurDonnees Adresse2, TypUpsVmLong Taille);
   /* Objet : Compare deux zones memoires. */
TypUpsVmPointeurDonnees UpsVmAPI (*AllouerMemoirePartagee)(TypUpsVmChar *NomMemoire, TypUpsVmLong Taille, 
   TypUpsVmPointeurDonnees *HandleMemoire, TypUpsVmLong Cle, enum EnuUpsVtmMemoirePartagee Mode);
   /* Objet : Cree ou retrouve une memoire partagee. */
TypUpsVmShort UpsVmAPI (*LibererMemoirePartagee)(TypUpsVmPointeurDonnees Adresse, TypUpsVmPointeurDonnees HandleMemoire,
   enum EnuUpsVtmMemoirePartagee Mode);
   /* Objet : Libere une memoire partagee. */
TypUpsVmVoid UpsVmAPI (*EcrireEcran)(TypUpsVmChar *Message);
   /* Objet : Ecrit un message a la console. */
TypUpsVmVoid UpsVmAPI (*ArreterProgramme)(TypUpsVmShort CodeRetour);
   /* Objet : Arrete proprement le programme. */
TypUpsVmVoid UpsVmAPI (*GererSignaux)(TypUpsVmShort Proteger);
   /* Objet : Genere les signaux recus par le thread. */
TypUpsVmChar UpsVmAPI *(*LireEnvironnement)(TypUpsVmChar *NomVariable);
   /* Objet : Lit une variable environnement. */
TypUpsVmLong UpsVmAPI (*CalculerOffset)(TypUpsVmPointeurDonnees Adresse1, TypUpsVmPointeurDonnees Adresse2);
   /* Objet : Retourne Adresse1-Adresse2. */
TypUpsVmShort UpsVmAPI (*DevenirDemon)(TypUpsVmVoid);
   /* Objet : Devient un demon. */
TypUpsVmShort UpsVmAPI (*CalculerUpsHome)(TypUpsVmChar *UpsHome);
   /* Objet : Recherche UPS_HOME. */
TypUpsVmShort UpsVmAPI (*CalculerUpsPath)(TypUpsVmChar *UpsPath);
   /* Objet : Recherche UPS_PATH. */
TypUpsVmShort UpsVmAPI (*CalculerUpsNls)(TypUpsVmChar *UpsNls);
   /* Objet : Recherche UPS_NLS. */
TypUpsVmShort UpsVmAPI (*CalculerUpsLanguage)(TypUpsVmChar *UpsLanguage);
   /* Objet : Recherche UPS_LANGUAGE. */
} *TypUpsVtmMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsVtmMachineInterface_1_1_0 TypUpsVtmMachineInterface;

typedef TypUpsVmPointeurTraitements *(*TypUpsVtmAPIDemarrerNat)(TypUpsVtmMachineInterface MachineInterface);

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
