/*-------------------------------------------------------------------
Fichier     : upsvtm.e
Objet       : Chargement et terminaison d'Up ! Virtual Technical Machine.

Module      : Up ! Virtual Technical Machine
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsVtm)
/*****************************/
#define PasseModuleUpsVtm 1

#include <upsvtm_nt.e>
#include <upspgc.e>

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/*******************************************************************/
/* Codification des plates-formes supportees par                   */
/* Up ! Virtual Technical Machine.                                 */
/*******************************************************************/
enum EnuUpsVtmPlateForme
   {
   PL_Macintosh=1,
   PL_Os390=2,
   PL_Os400=3,
   PL_Unix=4,
   PL_Win32=5,
   PL_Up5GL=6
   };

/*******************************************************************/
/* Codification des types de memoire.                              */
/*******************************************************************/
enum EnuUpsVtmTypeMemoire
   {
   TM_Privee=1,
   TM_Protegee=2,
   TM_Publique=3
   };
 
/*******************************************************************/
/* Codification des modes de chargement.                           */
/*******************************************************************/
enum EnuUpsVtmLireInterface
   {
   LI_NePasCharger=1,
   LI_Charger=2,
   LI_ChargerDictionnaire=3,
   LI_ChargerClientCorba=4,
   LI_ChargerClientCom=5,
   LI_ChargerClientJava=6,
   LI_ChargerClientUpsNet=7,
   LI_ChargerServeurCorba=8,
   LI_ChargerServeurCom=9,
   LI_ChargerServeurJava=10,
   LI_ChargerServeurUpsNet=11
   };

/****************************************************************/
/* Codification des modes de passage des parametres.            */
/****************************************************************/
enum EnuUpsVmModePassageParametre
   {
   PR_EnumereCourtParEntree=1,
      /* P(E : EnuAMoinsDe255Valeurs Entree); */
   PR_EnumereLongParEntree=2,
      /* P(E : EnuAPlusDe256Valeurs Entree); */
   PR_EntierParEntree=3,
      /* P(E: E ntier Entree); */
   PR_ReelParEntree=4,
      /* P(R : Reel Entree); */
   PR_ObjetParEntree=5,
      /* P(O : Objet Entree); */
   PR_EnumereCourtParSortie=11,
      /* P(E:EnuAMoinsDe255Valeurs Sortie); */
   PR_EnumereLongParSortie=12,
      /* P(E:EnuAPlusDe256Valeurs Sortie); */
   PR_EntierParSortie=13,
      /* P(E:Entier Sortie); */
   PR_ReelParSortie=14,
      /* P(R:Reel Sortie); */
   PR_ObjetParSortie=15,
      /* P(O:Objet Sortie); */
   PR_EnumereCourtParEntreeSortie=21,
      /* P(E:EnuAMoinsDe255Valeurs Entree Sortie); */
   PR_EnumereLongParEntreeSortie=22,
      /* P(E:EnuAPlusDe256Valeurs Entree Sortie); */
   PR_EntierParEntreeSortie=23,
      /* P(E:Entier EntreeSortie); */
   PR_ReelParEntreeSortie=24,
      /* P(R:Reel Entree Sortie); */
   PR_ObjetParEntreeSortie=25
      /* P(O:Objet Entree Sortie); */
   };

/****************************************************************/
/* Codification du mode de lancement.					        		 */
/****************************************************************/
enum EnuUpsVmModeLancement
   {
   ML_Interactif=1,
   ML_Serveur=2,
   ML_Automatique=3,
   ML_Console=4,
   ML_Com=5,
   ML_Corba=6,
   ML_Java=7
   };

/****************************************************************/
/* Codification du mode d'automation.				                */
/****************************************************************/
enum EnuUpsVmModeAutomation
   {
   AU_Sans=1,
   AU_Executer=2,
   AU_Charger=3,
   AU_Decharger=4
   };

/****************************************************************/
/* Codification des types de traitements.                       */
/****************************************************************/
enum EnuUpsVmTypeDeTraitements
   {
   TT_NatifCompile=1,
   TT_ScriptInterprete=2,
   TT_NatifCorba=3,
   TT_NatifCom=4,
   TT_NatifJava=5
   };

/****************************************************************/
/* Codification des modes d'appels possibles.                   */ 
/****************************************************************/
enum EnuUpsVmModeDAppel
   {
   TA_ProcedureSansParametre=1,
      /* Procedure P(); */
   TA_ProcedureAvecParametre=2,
      /* Procedure P(PP : Objet, ...); */
   TA_FonctionEnumereCourtSansParametre=3,
      /* Fonction F() Retourner Enumere; */
   TA_FonctionEnumereCourtAvecParametre=4,
      /* Fonction F(PP : Objet, ...) Retourner Enumere; */
   TA_FonctionEnumereLongSansParametre=5,
      /* Fonction F() Retourner Booleen; */
   TA_FonctionEnumereLongAvecParametre=6,
      /* Fonction F(PP : Objet, ...) Retourner Enumere; */
   TA_FonctionEntierSansParametre=7,
      /* Fonction F() Retourner Entier; */
   TA_FonctionEntierAvecParametre=8,
      /* Fonction F(PP : Objet, ...) Retourner Entier; */
   TA_FonctionReelSansParametre=9,
      /* Fonction F() Retourner Reel; */
   TA_FonctionReelAvecParametre=10,
      /* Fonction F(PP : Objet, ...) Retourner Reel; */
   TA_FonctionObjetSansParametre=11,
      /* Fonction F() Retourner Objet; */
   TA_FonctionObjetAvecParametre=12,
      /* Fonction F(PP : Objet, ...) Retourner Objet; */
   TA_MethodeSansParametre=13,
      /* Procedure T.P(); */
   TA_MethodeAvecParametre=14,
      /* Procedure T.P(PP : Objet, ...); */
   TA_MethodeEnumereCourtSansParametre=15,
      /* Fonction T.F() Retourner Booleen; */
   TA_MethodeEnumereCourtAvecParametre=16,
      /* Fonction T.F(PP : Objet, ...) Retourner Enumere; */
   TA_MethodeEnumereLongSansParametre=17,
      /* Fonction T.F() Retourner Booleen; */
   TA_MethodeEnumereLongAvecParametre=18,
      /* Fonction T.F(PP : Objet, ...) Retourner Enumere; */
   TA_MethodeEntierSansParametre=19,
      /* Fonction T.F() Retourner Entier; */
   TA_MethodeEntierAvecParametre=20,
      /* Fonction T.F(PP : Objet, ...) Retourner Entier; */
   TA_MethodeReelSansParametre=21,
      /* Fonction T.F() Retourner Reel; */
   TA_MethodeReelAvecParametre=22,
      /* Fonction T.F(PP:Objet, ...) Retourner Reel; */
   TA_MethodeObjetSansParametre=23,
      /* Fonction T.F() Retourner Objet; */
   TA_MethodeObjetAvecParametre=24
      /* Fonction T.F(PP:Objet, ...) Retourner Objet; */
   };

/****************************************************************/
/* Codification de l'architecture d'un objet.                   */
/****************************************************************/
enum EnuUpsVmArchitectureObjet
   {
   AO_EstBigEndian=0x1,
      /* Si Vrai, la plate-forme qui a cree l'objet fonctionne en Big Endian. */  
   AO_16Bits=0x2,
      /* Si Vrai, la plate-forme qui a cree l'objet fonctionne en 16 bits. */  
   AO_32Bits=0x4,
      /* Si Vrai, la plate-forme qui a cree l'objet fonctionne en 32 bits. */  
   AO_64Bits=0x8,
      /* Si Vrai, la plate-forme qui a cree l'objet fonctionne en 64 bits. */  
   AO_EstUnObjetCom=0x10,
      /* L'objet encapsule un objet Com. */
   AO_EstUnObjetCorba=0x20,
      /* L'objet encapsule un objet Corba. */
   AO_EstUnObjetJava=0x40
      /* L'objet encapsule un objet Java. */
   };

/****************************************************************/
/* Codification des options d'un objet.                         */
/****************************************************************/
enum EnuUpsVmOptionObjet
   {
   OO_EstTransactionnel=0x1,
      /* L'objet est transactionnel. */
   OO_SupporteProprietesDynamiques=0x2,
      /* L'objet supporte les proprietes dynamiques. */
   OO_SupporteHabilitations=0x4,
      /* L'objet supporte les habilitations. */
   OO_EstDUneInterface=0x8,
      /* L'objet provient d'une interface et non d'un type. */
   OO_EstUneRessource=0x10,
      /* L'objet encapsule une ressource propre a l'OS et au processus. */
   OO_SupporteAppartenance=0x20,
      /* L'objet supporte l'appartenance. */
   OO_SupporteQuota=0x40
      /* L'objet supporte les quotas. */
   };

/****************************************************************/
/* Operateurs.                                                  */
/****************************************************************/
enum EnuUpsVmOperateur
   {
/*--------------------------------------------*/
/* Codification des operations arithmetiques. */
/*--------------------------------------------*/
   OP_Additionner=1,
   OP_Soustraire=2,
   OP_Multiplier=3,
   OP_Diviser=4,
   OP_DiviserEntier=5,
   OP_Moduler=6,
   OP_Puissance=7,
   OP_EtBit=8,
   OP_OuBit=9,
   OP_NonBit=10,
   OP_InferieurInferieur=11,
   OP_SuperieurSuperieur=12,
   OP_Incrementer=13,
   OP_Decrementer=14,
/*---------------------------------------------*/
/* Codification des operations de comparaison. */
/*---------------------------------------------*/
   OP_Egal=15,
   OP_Different=16,
   OP_Inferieur=17,
   OP_Superieur=18,
   OP_InferieurOuEgal=19,
   OP_SuperieurOuEgal=20,
   OP_Affecter=21,
/*-----------------------------------------*/
/* Codification des operations composes.   */
/*-----------------------------------------*/
   OP_AdditionnerAffecter=22,
   OP_SoustraireAffecter=23,
   OP_MultiplierAffecter=24,
   OP_DiviserAffecter=25,
   OP_DiviserEntierAffecter=26,
   OP_ModulerAffecter=27,
   OP_PuissanceAffecter=28,
   OP_EtBitAffecter=29,
   OP_OuBitAffecter=30,
   OP_InferieurInferieurAffecter=31,
   OP_SuperieurSuperieurAffecter=32,
/*-----------------------------------------*/
/* Codification des operations booleennes. */
/*-----------------------------------------*/
   OP_Non=33,
   OP_Et=34,
   OP_Ou=35,
   OP_OuExclusif=36,
/*-------------------------------------------*/
/* Codification des operations ensemblistes. */
/*-------------------------------------------*/
   OP_Union=37,
   OP_Intersection=38,
   OP_Soustraction=39,
/*-----------------------------------------*/
/* Codification des operations diverses.   */
/*-----------------------------------------*/
   OP_EtSi=40,
   OP_OuSinon=41,
   OP_Tableau=42,
   OP_Evaluation=43,
   OP_MiseEnFile=44
   };

/****************************************************************/
/* Resultat d'une action utilisateur suite l'execution d'une    */
/* etape.														             */
/****************************************************************/
enum EnuUpsVmAction
   {
   AC_Succes=1,
   AC_ArreterRegle=2,
   AC_ArreterTout=3,
   AC_ReprendreSansErreur=4,
   AC_ArreterToutSansErreur=5,
   AC_SuccesFinal=10
   };

/****************************************************************/
/* Action de correction des erreurs de syntaxe.                 */
/****************************************************************/
enum EnuUpsVmCorrection
   {
   AC_Ajouter=1,
   AC_AjouterEntier=2,
   AC_AjouterReel=3,
   AC_AjouterChaineGuillemets=4,
   AC_AjouterChaineApostrophes=5,
   AC_Supprimer=6,
   AC_Modifier=7
   };

/****************************************************************/
/* Cible d'execution.                                           */
/****************************************************************/
enum EnuUpsVmCibleExecution
   {
   CE_Compiler=1,
   CE_Engine=2
   };

/********************************************/
/* Codification des etapes du parcours.     */
/********************************************/
enum EnuUpsVmEtapeParcours
   {
   PR_Initialiser=1,
   PR_DescendreGauche=2,
   PR_DescendreDroit=3,
   PR_Orphelin=4,
   PR_Basculer=5,
   PR_Remonter=6
   };
   
/***********************************************/
/* Codification de la nature des objets crees. */
/***********************************************/
enum EnuUpsVmNatureObjet
   {
   NO_SystemeAutomatique=1,
   NO_SystemeBaseDeDonnees=2,
   NO_UtilisateurAutomatique=3,
   NO_UtilisateurBaseDeDonnees=4
   };
   
#define CO_NumeroServeurUpsOrbMaitre 65535
   /* Numero du serveur Ups Orb maitre. */
#define CO_NumeroServeurParDefaut 65534
   /* Numero du serveur par defaut. */
#define CO_NbIterateurs 4
   /* Nombre d'iterateurs pour les listes. */
#define CO_NbMethodesGeneriques (TypUpsVmShort)(sizeof(struct typupsvmentetemethodes)/sizeof(TypUpsVmPointeurTraitements))
   /* Nombre de methodes generiques dans TypUpsVmEnteteMethodes. 22 a ce jour. */
#define CO_Version 1
   /* Version de Ups Vm. */
#define CO_Revision 1
   /* Revision de Ups Vm. */
#define CO_Correction 0
   /* Revision de Ups Vm. */
#define CO_TailleTampon 32
   /* Nombre de caracteres remis dans le tampon lors de la lecture d'un flux. */
#define CO_NbSegmentsDonnees 24
   /* Nombre maximal de segments de donnes proteges par module i.e. de composants. */
#define CO_NbModulesMax 50
   /* Nombre maximal de modules. */
#define CO_NbParametresMax 255
   /* Nombre maximal de parametres. */

/****************************************************************/
/* Definitions recursives.                                      */
/****************************************************************/
typedef struct typupsvtmtraitements_1_1_0 *TypUpsVtmTraitements_1_1_0;
typedef struct typupsvtmdonnees *TypUpsVtmDonnees;
typedef struct typupsvmentetedonneesmodule *TypUpsVmEnteteDonneesModule;
typedef struct typupsvmentetemethodesmodule *TypUpsVmEnteteMethodesModule;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsVtmTraitements_1_1_0 TypUpsVtmTraitements;

typedef struct typupsvtmdemarrer *(*TypUpsVtmAPIDemarrer)(TypUpsVmShort NumeroModule, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
typedef TypUpsVmShort UpsVmAPI (*TypUpsVtmAPIInitialiserModule)(TypUpsVmVoid);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVtmAPITerminerModule)(TypUpsVmVoid);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVtmAPIChangerInstance)(TypUpsVmChar *NomModule, TypUpsVmEnteteDonneesModule Interface);
typedef TypUpsVmEnteteMethodesModule UpsVmAPI (*TypUpsVtmAPILireInterfaceModule)(TypUpsVmShort Version, TypUpsVmShort Revision, 
   TypUpsVmShort Correction);
typedef TypUpsVmShort (*TypUpsVmPrincipal)(TypUpsVmVoid);

/*******************************************************************/
typedef struct typupsvtmsegmentdonnee
/* Objet : Definition d'un segment de donnee.                      */ 
/*******************************************************************/
{
TypUpsVmLong Taille;
   /* Taille du segment. */
enum EnuUpsVtmTypeMemoire TypeMemoire;
   /* Type de memoire pour le segment de donnees. */
TypUpsVmPointeurDonnees *Donnees;
   /* Adresse de l'adresse du segment de donnees. */
} TypUpsVtmSegmentDonnee;

/*******************************************************************/
typedef struct typupsvtmsegmentsdonnees
/* Objet : Definition des segments de donnees.                     */ 
/*******************************************************************/
{
TypUpsVtmSegmentDonnee Protege;
   /* Pour les donnees protegees. */
TypUpsVtmSegmentDonnee Prive;
   /* Pour les donnees privees. */
} TypUpsVtmSegmentsDonnees;
   
/*******************************************************************/
typedef struct typupsvtmdemarrer
/* Objet : Interface de demarrage entre un module et Up ! Vmt.     */
/*******************************************************************/
{
TypUpsVmShort Priorite;
   /* Priorite du module par rapport aux autres pour l'initialisation et la terminaison. */
TypUpsVmShort Version;
   /* Version du module vis-a-vis de Up ! Virtual Technical Machine. */
TypUpsVmShort Revision;
   /* Revision du module vis-a-vis de Up ! Virtual Technical Machine. */
TypUpsVmShort Correction;
   /* Correction du module vis-a-vis de Up ! Virtual Technical Machine. */
enum EnuUpsVtmLireInterface TypeModule;
   /* Type de module. */
TypUpsVtmAPILireInterfaceModule LireInterfaceModule;
   /* Lit l'interface des traitements du module et transmet la au serveur de modules. */
TypUpsVtmAPIInitialiserModule InitialiserModule;
   /* Initialise le module module. */
TypUpsVtmAPITerminerModule TerminerModule;
   /* Termine le module module. */
TypUpsVtmAPIChangerInstance ChangerInstance;
   /* Previent le module d'un changement d'instance. */
TypUpsVmLong Cle;
   /* Cle en cas de memoire partagee. */
TypUpsVtmSegmentDonnee Public;
   /* Pour les donnees publiques. */
TypUpsVtmSegmentDonnee Protege;
   /* Pour les donnees protegees. */
TypUpsVtmSegmentsDonnees TableDonnees[CO_NbSegmentsDonnees];
   /* Table des segments de donnees de chaque composant. */
} *TypUpsVtmDemarrer;

/*******************************************************************/
struct typupsvtmtraitements_1_1_0
/* Objet : Interface de traitements de Up ! Vtm.                   */ 
/*******************************************************************/
{
TypUpsVmShort UpsVmAPI (*ComparerVersionRevision)(TypUpsVmShort Version1, TypUpsVmShort Revision1, TypUpsVmShort Correction1, 
   TypUpsVmShort Version2, TypUpsVmShort Revision2, TypUpsVmShort Correction2);
   /* Objet : Compare les versions-revisions a la strcmp.             */
TypUpsVmEnteteMethodesModule UpsVmAPI (*LireInterfaceModule)(TypUpsVmChar *NomModule, enum EnuUpsVtmLireInterface TypeModule,
   TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction);
   /* Lit l'interface des traitements du module demande et retourne le au module appelant. */
TypUpsVmEnteteMethodesModule UpsVmAPI (*LireInterfaceModuleParNumero)(TypUpsVmShort NumeroModule, 
   TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction);
   /* Objet : Retrouve l'interface d'un module.	*/
TypUpsVmPointeurTraitements UpsVmAPI *(*LireInterfaceModuleNat)(TypUpsVmChar *NomModule);
   /* Lit l'interface des traitements du module UpsSysNat et retourne le au module appelant. */
TypUpsVmShort UpsVmAPI (*LireNumeroModule)(TypUpsVmChar *NomModule, enum EnuUpsVtmLireInterface ChargerSiNonExistant);
   /* Retrouve le numero d'un module. */
TypUpsVmChar UpsVmAPI *(*LireNomModule)(TypUpsVmShort NumeroModule, TypUpsVmChar *NomModule, TypUpsVmLong TailleNomModule, 
   TypUpsVmShort PourUnFichier);
   /* Retrouve le nom d'un module. */
TypUpsVmShort UpsVmAPI (*LireNbModules)(TypUpsVmVoid);
   /* Retrouve le nombre de modules. */
TypUpsVmChar UpsVmAPI *(*LireNomDuNIemeModule)(TypUpsVmShort NumeroModule, TypUpsVmShort *Version,
   TypUpsVmShort *Revision, TypUpsVmShort *Correction);
   /* Objet : Retrouve le nom du iem module. */
TypUpsVmShort UpsVmAPI (*AjouterModule)(TypUpsVmChar *NomModule, TypUpsVmShort EnvoyerErreur,
   enum EnuUpsVtmLireInterface TypeModule);
   /* Objet : Ajoute un module dynamique. */
TypUpsVmShort UpsVmAPI (*SupprimerModule)(TypUpsVmShort NumeroModule);
   /* Objet : Supprime un module dynamique. */
TypUpsVmShort UpsVmAPI (*NouvelleInstance)(TypUpsVmVoid);
   /* Objet : Cree une nouvelle instance. Il n'y a pas de changement d'instance. */
TypUpsVmShort UpsVmAPI (*ChangerInstance)(TypUpsVmShort NumeroInstance);
   /* Objet : Changement d'instance. */
TypUpsVmShort UpsVmAPI (*TerminerInstance)(TypUpsVmShort NumeroInstance);
   /* Objet : Termine une instance. */
};

/*******************************************************************/
struct typupsvtmdonnees
/* Objet : Interface de donnees de Up ! Vtm.                       */ 
/*******************************************************************/
{
TypUpsVmShort argc;
   /* Nombre d'arguments. */
TypUpsVmChar **argv;
   /* Vecteur d'arguments. */
TypUpsVmChar **env;
   /* Vecteur des variables environnement. */
TypUpsVmChar *ChaineArguments;
   /* Chaine d'arguments. */
TypUpsVmChar UpsHome[CO_TailleNomFichier+1];
   /* Valeur de UPS_HOME. */
TypUpsVmChar UpsPath[CO_TailleLigneMax+1];
   /* Valeur de UPS_PATH. */
TypUpsVmChar UpsNls[CO_TailleLigneMax+1];
   /* Valeur de UPS_NLS. */
TypUpsVmChar UpsLanguage[CO_TailleIdf+1];
   /* Valeur de UPS_LANGUAGE. */
TypUpsVmShort Version;
   /* Version de Ups Vm. */
TypUpsVmShort Revision;
   /* Revision du Ups Vm. */
TypUpsVmShort Correction;
   /* Correction du Ups Vm. */
TypUpsVmPointeurDonnees HandleInstanceCode;
   /* Numero de l'instance courante du systeme d'exploitation. */
TypUpsVmShort InstanceCourante;
   /* Numero de l'instance courante de Ups Vmt. */
TypUpsVmShort NbInstances;
   /* Nombre d'instances. */
enum EnuUpsVtmPlateForme PlateForme;
   /* PlateForme d'execution. */
TypUpsVmLireCleRessourcePartagee LireCleRessourcePartagee;
   /* Retrouve une ressource dans upssys.ini. */
TypUpsVtmGestionnaireSignal GestionnaireSignal;
   /* Gestionnaire de signaux. */
TypUpsVmShort IlExisteSegmentPartage;
   /* Si Vrai, il existe un segment de memoire partage. */
TypUpsVmShort ModeBatch;
   /* Si Vrai, le programme est execute en batch. */
enum EnuUpsVmModeLancement ModeLancement;
   /* Mode de lancement du programme. */
TypUpsVmShort Ascii;
   /* Si Vrai, la machine reelle est Ascii, sinon Ebcdic. */
TypUpsVmUnsignedChar EstBigEndian;
   /* Si Vrai, la plate-forme qui a cree l'objet fonctionne en Big Endian. */  
TypUpsVmUnsignedChar NbBits;
   /* 16, 32 ou 64 bits pour la plate-forme. */  
TypUpsVmShort EstUpsServeur;
   /* Si Vrai, il s'agit de Ups Serveur. */
enum EnuUpsVmModeAutomation AutomationCom;
   /* Mode d'appel du serveur Com pour Automation. */
enum EnuUpsVmModeAutomation AutomationCorba;
   /* Mode d'appel du serveur Corba pour Automation. */
enum EnuUpsVmModeAutomation AutomationJava;
   /* Mode d'appel du serveur Java pour Automation. */
enum EnuUpsVmModeAutomation AutomationUpsNet;
   /* Mode d'appel du serveur UpsNet pour Automation. */
TypUpsVmChar NomModulePrincipal[CO_TailleIdf+1];
   /* Nom du module principal. */
TypUpsVmShort NbTachesActives;
   /* Nombre de taches simultanement actives au niveau de Up ! Virtual Technical Machine. */
TypUpsVmShort RelancerProgramme;
   /* Si Vrai, il faut relancer le programme. */
TypUpsVmChar ParametresRelancer[CO_TailleBuffer+1];
   /* Parametres a utiliser au cours du relancement du programme. */
TypUpsVmUnsignedLong NbAllocations[CO_NbSortesMemoire+1];
   /* Nombre d'allocations par sorte de memoire. */
TypUpsVmPointeurDonnees Environnement;
   /* Environnement d'execution pour un adaptateur serveur. */
TypUpsVmShort NbLancements;
   /* Nombre de lancements de la machine virtuelle. */
};

/****************************************************************/
/* Definitions recursives.                                      */
/****************************************************************/
struct typupsnetprotocoleupsnet;
typedef struct typupsvtmraitementsoption TypUpsVmTraitementsOption;
typedef struct typupsvmdonneesoption TypUpsVmDonneesOption;

/****************************************************************/
typedef struct typupsvmiterateur
/* Objet : Iterateur d'une liste.                               */
/****************************************************************/
{
TypUpsVmLong NumeroElement;
   /* Numero de l'element courant. */
TypUpsVmAdresse ElementArbre;
   /* Pour les arbres binaires, element de l'arbre courant. */
enum EnuUpsVmEtapeParcours Parcours;
   /* Etape dans le parcours. */
TypUpsVmAdresse Element;
   /* Element en soi; */
TypUpsVmAdresse AdresseObjet;
   /* Objet pointe par l'element; */
TypUpsVmShort EstAvance;
   /* Si Vrai, l'element est deja avance. */
TypUpsVmLong AlloueParSession;
   /* Session ayant allouee l'iterateur. */
} TypUpsVmIterateur;

/****************************************************************/
typedef struct typupsvmextension
/* Objet: Description d'une extension d'un type.                */
/****************************************************************/
{
TypUpsVmShort NbExtensions;
   /* Nombre d'extensions dans la table. */
TypUpsVmShort NbExtensionsMax;
   /* Nombre d'extensions maximales dans la table. */
TypUpsVmAdresse ObjetBuffer;
   /* Segment dans lequel est alloue le buffer de la table des extensions. */
TypUpsVmLong Index;
   /* Index de la table des extensions dans le segment. */
TypUpsVmLong NbBuffers;
   /* Nombre d'elements consecutifs occupes par le buffer. */
} TypUpsVmExtension;

/****************************************************************/
typedef struct typupsvmsession
/* Objet: Description d'une session d'execution.                */
/****************************************************************/
{
TypUpsVmUnsignedShort NumeroSession;
   /* Numero de la session. */
TypUpsVmUnsignedShort NumeroEntrepot;
   /* Numero de l'entrepot dans laquelle doivent etre crees les objets. */
TypUpsVmUnsignedShort NumeroFichierEchange;
   /* Numero du fichier d'echange dans laquelle doivent etre crees les objets. */
TypUpsVmShort AlimenterEnregistrementJournal;
   /* Si Vrai, il faut enregistrer les modifications dans le journal. */
TypUpsVmShort IgnorerEtatEntrepot;
   /* Si Vrai, on ignore de l'etat de l'entrepot pour les acces disques. */
TypUpsVmShort IgnorerTransaction;
   /* Si Vrai, on ignore temporairement les transactions. */
TypUpsVmUnsignedShort NumeroSessionControlee;
   /* Numero de la session controlee par la session. */
TypUpsVmUnsignedLong NumeroCoherenceEnregistrement;
   /* Numero de coherence de l'enregistrement si cela est demande. */
TypUpsVmUnsignedShort NbCoherencesDemandees;
   /* Nombre de coherences demandees. */
enum EnuUpsVmNatureObjet NatureObjet;
   /* Nature des objets a creer. */
union 
   {
   TypUpsVmAdresse AdresseObjetFile;
      /* Pour une tache d'une file d'attente, adresse de l'objet de la file. */
   TypUpsVmUnsignedShort NumeroEntrepot;
      /* Pour la tache RetasserTousLesTypes. */
   TypUpsVmPointeurDonnees ServeurCourant;
      /* Pour une tache serveur. */
   } Selection;
} TypUpsVmSession;

typedef struct typupsvmmethodesflux_1_1_0 *TypUpsVmMethodesFlux_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsVmMethodesFlux_1_1_0 TypUpsVmMethodesFlux;

/****************************************************************/
typedef struct typupsvmflux
/* Objet: Descripteur d'un flux.                                */
/****************************************************************/
{
TypUpsVmPointeurDonnees Handle;
   /* Descripteur physique du flux. */
TypUpsVmShort PageDeCode;
   /* Page de code du flux. */
TypUpsVmChar Buffer[CO_TailleTampon];
   /* Tampon pour rejeter des caracteres. */
TypUpsVmShort NbCaracteresDansBuffer;
   /* Nombre de caracteres dans le buffer. */
TypUpsVmShort PremiereEcriture;
   /* Si Vrai, il s'agit de la premiere ecriture. */
TypUpsVmShort ModeTexte;
   /* Si Vrai, le mode est texte i.e. on saute les \r automatiquement. */
TypUpsVmMethodesFlux Methodes;
   /* Methodes de bas niveau de gestion du flux. */
} TypUpsVmFlux;

/****************************************************************/
struct typupsvmmethodesflux_1_1_0
/* Objet: Definiton des methodes d'un flux.                     */
/****************************************************************/
{
TypUpsVmPointeurDonnees UpsVmAPI (*Ouvrir)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFlux, TypUpsVmUnicode *Masque, enum EnuUpsVmTailleBuffer TailleBuffer);
   /* Objet : Ouvre le flux. */
TypUpsVmShort UpsVmAPI (*Lire)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Handle, TypUpsVmChar *Buffer, TypUpsVmLong TailleALire,
   TypUpsVmLong *TailleLue);
   /* Objet : Lit un paquet d'octets dans le flux. */
TypUpsVmShort UpsVmAPI (*Ecrire)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Handle, TypUpsVmChar *Buffer, TypUpsVmLong TailleAEcrire,
   TypUpsVmLong *TailleEcrite);
   /* Objet : Ecrit d'un paquet d'octets dans le flux. */
TypUpsVmLong UpsVmAPI (*LirePositionPointeur)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Handle);
   /* Objet : Lit la position dans le flux. */
TypUpsVmShort UpsVmAPI (*DeplacerPositionPointeur)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Handle, enum EnuUpsVmDeplacement Reference, TypUpsVmLong Position);
   /* Objet : Fixe la position dans le flux. */
TypUpsVmShort UpsVmAPI (*Vider)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Handle);
   /* Objet : Vide le flux. */
TypUpsVmShort UpsVmAPI (*Fermer)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Handle);
   /* Objet : Ferme le flux. */
};

/****************************************************************/
typedef struct typprmupsvmenumererparametres
/* Objet : Parametres de la methode EnumererParametres.         */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero : Entier. */
TypUpsVmAdresse UpsVar2;
   /* TypeParametre : Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar3;
   /* PeutEtreNul : Booleen. */
TypUpsVmAdresse UpsVar4;
   /* Aide : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* NomEnumere : Nul Ou Caractere. */
TypUpsVmUnsignedChar UpsVar6;
   /* SorteDuParametre:SorteParametre; */
TypUpsVmUnsignedChar UpsVar7;
   /* IlExisteValeurParDefaut:Booleen; */
} TypPrmUpsVmEnumererParametres;

/****************************************************************/
typedef struct typprmupsvmenumererenumeres
/* Objet : Parametres de la methode EnumererEnumeres.           */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsVmEnumererEnumeres;

/****************************************************************/
typedef struct typprmupsvmenumerervaleursenumeres
/* Objet : Parametres de la methode EnumererValeursEnumeres.    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomEnumere:Caractere; */
TypUpsVmLong UpsVar2;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar3;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsVmEnumererValeursEnumeres;

/****************************************************************/
typedef struct typprmupsvmenumererentrepots
/* Objet : Parametres de la methode EnumererEntrepots.         */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsVmEnumererEntrepots;

/****************************************************************/
typedef struct typprmupsvmenumerertypes
/* Objet : Parametres de la methode EnumererTypes.              */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsVmEnumererTypes;

/****************************************************************/
typedef struct typprmupsvmenumerervariables
/* Objet : Parametres de la methode EnumererVariables.          */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero : Entier. */
TypUpsVmAdresse UpsVar2;
   /* TypeVariable : Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar3;
   /* PeutEtreNul : Booleen. */
TypUpsVmAdresse UpsVar4;
   /* Aide : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* NomEnumere : Nul Ou Caractere. */
} TypPrmUpsVmEnumererVariables;

/****************************************************************/
typedef struct typprmupsvmenumererexceptions
/* Objet : Parametres de la methode EnumererExceptions.         */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsVmEnumererExceptions;

/****************************************************************/
typedef struct typprmupsvmenumererappels
/* Objet : Parametres de la methode EnumererAppels.             */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* NomAppel:Caractere Sortie; */
TypUpsVmAdresse UpsVar3;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsVmEnumererAppels;

/****************************************************************/
typedef struct typprmupsvmecrirevariable
/* Objet : Parametres de la methode EcrireVariable.             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomVariable:Nul Ou Caractere; */
TypUpsVmValeur UpsVar2;
   /* ValeurVariable : Nul Ou Objet; */
} TypPrmUpsVmEcrireVariable;

/****************************************************************/
typedef struct typprmupsvmlirevariable
/* Objet : Parametres de la methode LireVariable.               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomVariable:Nul Ou Caractere; */
} TypPrmUpsVmLireVariable;

/****************************************************************/
typedef struct typprmupsvmincrementerdecrementervariable
/* Objet : Parametres de la methode                             */
/* IncrementerDecrementerVariable.                              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomVariable:Nul Ou Caractere; */
TypUpsVmUnsignedChar UpsVar2;
   /* Incrementer : booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* Prefixe : booleen. */
} TypPrmUpsVmIncrementerDecrementerVariable;

typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsVmCoAppel)(TypUpsVmSession *Session, 
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Fonction de description d'appel. */

/****************************************************************/
/* Objet : Definition des appels standardises d'un module.      */
/****************************************************************/
/*--------------------------------------------------------------*/
/* Pour Up ! Virtual Technical Machine.                         */
/*--------------------------------------------------------------*/
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmRechercherImplementationInterface)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *Interface);
   /* Retourne l'objet du type implementant l'interface; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmExecuterAppelDistant)(TypUpsVmSession *Session, struct typupsnetprotocoleupsnet *ProtocoleUpsNet, 
   TypUpsVmPointeurDonnees Parametres);
   /* Execute un appel distant. */
typedef TypUpsVmPointeurDonnees UpsVmAPI (*TypUpsVmLireEnteteDonneesModule)(TypUpsVmVoid);
   /* Retourne l'entete des donnees du module; */
typedef TypUpsVmShort UpsVmAPI (*TypUpsVmPrincipal)(TypUpsVmVoid);
   /* Objet : Fonction principale a executer. */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmEnregistrerPersistance)(TypUpsVmVoid);
   /* Objet : Enregistre la persistance du module. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsVmChargerPersistance)(TypUpsVmVoid);
   /* Objet : Charge la persistance du module. */
/*--------------------------------------------------------------*/
/* Pour le dictionnaire de donnees et de traitements.           */
/*--------------------------------------------------------------*/
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEnumererEnumeres)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererEnumeres *UpsPrm);
   /* Enumere les enumeres. */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEnumererValeursEnumeres)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererValeursEnumeres *UpsPrm);
   /* Enumere les valeurs d'un enumere. */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEnumererEntrepots)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererEntrepots *UpsPrm);
   /* Enumere les entrepots. */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEnumererTypes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererTypes *UpsPrm);
   /* Enumere les types. */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEnumererVariables)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererVariables *UpsPrm);
   /* Enumere les variables. */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEnumererExceptions)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererExceptions *UpsPrm);
   /* Enumere les exceptions. */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEnumererAppels)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererAppels *UpsPrm);
   /* Enumere les procedures ou les fonctions. */
/*--------------------------------------------------------------*/
/* Pour Up ! Kernel.                                            */
/*--------------------------------------------------------------*/
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeEcrireVariable)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEcrireVariable *UpsPrm);
typedef TypUpsVmVoid (*TypUpsVmMethodeLireVariable)(TypUpsVmSession *Session, 
   TypUpsVmValeur *ValeurResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmLireVariable *UpsPrm);
typedef TypUpsVmVoid (*TypUpsVmMethodeIncrementerDecrementerVariable)(TypUpsVmSession *Session, 
   TypUpsVmValeur *ValeurResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmIncrementerDecrementerVariable *UpsPrm);
/*--------------------------------------------------------------*/
/* Pour bibliotheques adaptateurs.                              */
/*--------------------------------------------------------------*/
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeChercherTypeClientCom)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees *Objet);
   /* Methode de recherche d'un type Com; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeChercherTypeServeurCom)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees *ObjetType, TypUpsVmPointeurDonnees *RefIId);
   /* Methode de recherche d'un type Com; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeChercherTypeClientCorba)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmUnicode *Identifiant);
   /* Methode de recherche d'un type Corba; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeChercherTypeServeurCorba)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees *ObjetType);
   /* Methode de recherche d'un type Corba; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeChercherTypeClientJava)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees Objet);
   /* Methode de recherche d'un type Java; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeChercherTypeServeurJava)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees *Classe);
   /* Methode de recherche d'un type Java; */
typedef TypUpsVmShort UpsVmAPI (*TypUpsVmMethodeAttacherTache)(TypUpsVmSession *Session);
   /* Methode d'attachement d'une tache a un systeme tiers; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeDetacherTache)(TypUpsVmSession *Session);
   /* Methode de detachement d'une tache d'un systeme tiers; */

/****************************************************************/
struct typupsvmentetemethodesmodule
/* Objet : En-tete de toutes les methodes des modules.          */
/****************************************************************/
{
/*--------------------------------------------------------------*/
/* Pour Up ! Virtual Technical Machine.                         */
/*--------------------------------------------------------------*/
TypUpsVmShort Version;
   /* Version applicative du module. */
TypUpsVmShort Revision;
   /* Revision applicative du module. */
TypUpsVmShort Correction;
   /* Correction applicative du module. */
TypUpsVmRechercherImplementationInterface RechercherImplementationInterface;
   /* Retourne l'objet du type implementant l'interface; */
TypUpsVmExecuterAppelDistant ExecuterAppelDistant;
   /* Execute un appel distant. */
TypUpsVmLireEnteteDonneesModule LireEnteteDonneesModule;
   /* Retourne l'entete des donnees du module; */
TypUpsVmPrincipal Principal;
   /* Objet : Principal a executer. */
TypUpsVmEnregistrerPersistance EnregistrerPersistance;
   /* Objet : Enregistre la persistance du module. */
TypUpsVmChargerPersistance ChargerPersistance;
   /* Objet : Charge la persistance du module. */
/*--------------------------------------------------------------*/
/* Pour le dictionnaire de donnees et de traitements.           */
/*--------------------------------------------------------------*/
TypUpsVmMethodeEnumererEnumeres MethodeEnumererEnumeres;
   /* Objet : Enumeration des enumeres. */
TypUpsVmMethodeEnumererValeursEnumeres MethodeEnumererValeursEnumeres;
   /* Objet : Enumeration des valeurs des enumeres. */
TypUpsVmMethodeEnumererEntrepots MethodeEnumererEntrepots;
   /* Objet : Enumeration des entrepots. */
TypUpsVmMethodeEnumererTypes MethodeEnumererTypes;
   /* Objet : Enumeration des types. */
TypUpsVmMethodeEnumererVariables MethodeEnumererVariables;
   /* Objet : Enumeration des variables. */
TypUpsVmMethodeEnumererExceptions MethodeEnumererExceptions;
   /* Objet : Enumeration des exceptions. */
TypUpsVmMethodeEnumererAppels MethodeEnumererAppels;
   /* Objet : Enumeration des appels. */
/*--------------------------------------------------------------*/
/* Pour Up ! Kernel.                                            */
/*--------------------------------------------------------------*/
TypUpsVmMethodeEcrireVariable MethodeEcrireVariable;
   /* Objet : Pour ecrire une variable globale. */
TypUpsVmMethodeLireVariable MethodeLireVariable;
   /* Objet : Pour lire une variable globale. */
TypUpsVmMethodeIncrementerDecrementerVariable MethodeIncrementerDecrementerVariable;
   /* Objet : Pour incrementer ou decrementer une variable globale. */
/*--------------------------------------------------------------*/
/* Pour bibliotheques adaptateurs.                              */
/*--------------------------------------------------------------*/
TypUpsVmMethodeChercherTypeClientCom MethodeChercherTypeClientCom;
   /* Methode de recherche d'un type Com; */
TypUpsVmMethodeChercherTypeServeurCom MethodeChercherTypeServeurCom;
   /* Methode de recherche d'un type Com; */
TypUpsVmMethodeChercherTypeClientCorba MethodeChercherTypeClientCorba;
   /* Methode de recherche d'un type Corba; */
TypUpsVmMethodeChercherTypeServeurCorba MethodeChercherTypeServeurCorba;
   /* Methode de recherche d'un type Corba; */
TypUpsVmMethodeChercherTypeClientJava MethodeChercherTypeClientJava;
   /* Methode de recherche d'un type Java; */
TypUpsVmMethodeChercherTypeServeurJava MethodeChercherTypeServeurJava;
   /* Methode de recherche d'un type Java; */
TypUpsVmMethodeAttacherTache MethodeAttacherTache;
   /* Methode d'attachement d'une tache a un systeme tiers; */
TypUpsVmMethodeDetacherTache MethodeDetacherTache;
   /* Methode de detachement d'une tache d'un systeme tiers; */
};

/****************************************************************/
typedef struct typupsvmentetesegmentdonnees
/* Objet : En-tete d'un segment de donnees.                     */
/****************************************************************/
{
TypUpsVmLong NbUtilisations;
   /* Nombre d'utilisations pour le multi-instance ou le multi-processus. */
} TypUpsVmEnteteSegmentDonnees;

/****************************************************************/
struct typupsvmentetedonneesmodule
/* Objet : En-tete de toutes les interfaces de donnees des      */
/* modules.                                                     */
/****************************************************************/
{
TypUpsVmEnteteSegmentDonnees EnteteSegmentDonnees;
   /* Nombre d'utilisations pour le multi-instance ou le multi-processus. */
TypUpsVmAdresse Module;
   /* Objet representant le module; */
TypUpsVmShort LicenceDefautChargementDynamique;
   /* Licence minimale par defaut en cas de chargement dynamique. */
};

/****************************************************************/
typedef struct typupsvtmraitementsoption
/* Objet: Interface des traitements d'une option.               */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 
TypUpsVmShort UpsVmAPI (*RechercherOption)(TypUpsVmUnicode *NomTypeOption, TypUpsVmTraitementsOption **IntTrt, 
   TypUpsVmDonneesOption **IntDon); 
   /* Objet : Recherche une option donnee par son interface de traitements et de donnees. */
TypUpsVmUnicode UpsVmAPI *(*LireLibelleOption)(TypUpsVmSession *Session);
   /* Objet : Lit le libelle de l'option. */
TypUpsVmShort UpsVmAPI (*ActiverOption)(TypUpsVmSession *Session, enum EnuUpsVmCibleExecution CibleExecution, TypUpsVmLong NumeroSemantique);
   /* Objet : Active l'option en fonction du contexte. */
} TypUpsVmTraitementsOption;

/****************************************************************/
typedef struct typupsvmdonneesoption
/* Objet: Interface des donnees d'une option.                   */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
TypUpsVmShort NumeroOption;
   /* Index dans la table des extensions. */
} TypUpsVmDonneesOption;

/****************************************************************/
typedef struct typupsvmoption
/* Objet: Options des modules.       						          */
/****************************************************************/
{
TypUpsVmUnicode NomOption[CO_TailleIdf+1];
   /* Nom de l'option. */
TypUpsVmTraitementsOption *IntTrtOption;
   /* Interface de traitements d'une option. */
TypUpsVmDonneesOption *IntDonOption;
   /* Interface de donnees d'une option. */
TypUpsVmShort *TableGestionOptions;
   /* Table de gestion des options. Il y a une entree par session. */
   /* L'entree 0 correspond a CO_SessionInterne. */
} TypUpsVmOption;

/****************************************************************/
typedef struct typprmupsvmcloner
/* Objet : Parametres de la methode Cloner.                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* EntrepotCible : Nul Ou Entrepot. */
TypUpsVmUnsignedChar UpsVar2;
   /* Profondeur : ProfondeurClonage. */
} TypPrmUpsVmCloner;

/****************************************************************/
typedef struct typprmupsvmimporter
/* Objet : Parametres de la methode Importer.                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* EntrepotCible : Nul Ou Entrepot. */
} TypPrmUpsVmImporter;

/****************************************************************/
typedef struct typprmupsvmlirepropriete
/* Objet : Parametres de la methode LirePropriete.              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* N : Nul Ou Caractere. */
} TypPrmUpsVmLirePropriete;

/****************************************************************/
typedef struct typprmupsvmecrirepropriete
/* Objet : Parametres de la methode EcrirePropriete.            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* N : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* V : Nul Ou Caractere. */
} TypPrmUpsVmEcrirePropriete;

/****************************************************************/
typedef struct typprmupsvmincrementerdecrementerpropriete
/* Objet : Parametres de la methode                             */
/* IncrementerDecrementerPropriete.                             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* N : Nul Ou Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* Incrementer : Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* Prefixe : Booleen. */
} TypPrmUpsVmIncrementerDecrementerPropriete;

/****************************************************************/
typedef struct typprmupsvmsupprimerpropriete
/* Objet : Parametres de la methode SupprimerEcrire.            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* N : Nul Ou Caractere. */
} TypPrmUpsVmSupprimerPropriete;

/****************************************************************/
typedef struct typprmupsvmenumererproprietes
/* Objet : Parametres de la methode EnumererProprietes.         */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero : Entier. */
TypUpsVmAdresse UpsVar2;
   /* TypePropriete : Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar3;
   /* PeutEtreNul : Booleen. */
TypUpsVmAdresse UpsVar4;
   /* Aide : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* NomEnumere : Nul Ou Caractere. */
} TypPrmUpsVmEnumererProprietes;

/****************************************************************/
/* Objet : Definition des appels standardises d'un objet.       */
/****************************************************************/
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmAllouer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType);
   /* Methode d'allocation d'un objet. */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmLiberer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Methode de liberation d'un objet. */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmConstructeur)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Constructeur(); */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmDestructeur)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Destructeur(); */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeAffecter)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *ObjetP);
   /* Operateur =(P:Nul Ou Objet); */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEgal)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *ObjetP);
   /* Operateur ==(P:Nul Ou Objet) Retourner Nul Ou Booleen; */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeDifferent)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *ObjetP);
   /* Operateur !=(P:Nul Ou Objet) Retourner Nul Ou Booleen; */
typedef TypUpsVmChar UpsVmAPI (*TypUpsVmMethodeCoherenceEntier)(TypUpsVmSession *Session, TypUpsVmLong UpsObjet, TypUpsVmAdresse *AdresseObjet);
   /* Contrainte pour un entier; */
typedef TypUpsVmChar UpsVmAPI (*TypUpsVmMethodeCoherenceReel)(TypUpsVmSession *Session, TypUpsVmDouble UpsObjet, TypUpsVmAdresse *AdresseObjet);
   /* Contrainte pour un reel; */
typedef TypUpsVmChar UpsVmAPI (*TypUpsVmMethodeCoherence)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Contrainte pour un Objet; */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeCloner)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmCloner *UpsPrm);
   /* Methode de clonage pour un Objet; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeExporter)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Methode d'exportation pour un Objet; */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeImporter)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmImporter *UpsPrm);
   /* Methode d'importation pour un Objet; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeAllouerRessource)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Methode d'allocation de la ressource pour un Objet; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeLibererRessource)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Methode de liberation de la ressource pour un Objet; */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeLirePropriete)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmLirePropriete *UpsPrm);
   /* Methode de lecture des proprietes pour un Objet; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeEcrirePropriete)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEcrirePropriete *UpsPrm);
   /* Methode d'ecriture des proprietes pour un Objet; */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeIncrementerDecrementerPropriete)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmIncrementerDecrementerPropriete *UpsPrm);
   /* Methode d'incrementation ou de decrementation des proprietes pour un Objet; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeSupprimerPropriete)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmSupprimerPropriete *UpsPrm);
   /* Methode de suppression des proprietes pour un Objet; */
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeEnumererProprietes)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEnumererProprietes *UpsPrm);
   /* Methode d'enumeration des proprietes pour un Objet; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmUtiliserObjetsChamps)(TypUpsVmSession *Session, TypUpsVmChar *Adresse);
   /* Utilise les champs d'un objet pour une transaction; */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmNePlusUtiliserObjetsChamps)(TypUpsVmSession *Session, TypUpsVmChar *Adresse);
   /* N'utilise plus les champs d'un objet pour une transaction; */

/****************************************************************/
typedef struct typupsvmentetemethodes
/* Objet : En-tete de toutes les methodes des objets de type    */
/* Objet.                                                       */
/****************************************************************/
{
TypUpsVmLiberer Liberer;
   /* Liberer(); */
TypUpsVmConstructeur Constructeur;
   /* Constructeur(); */
TypUpsVmDestructeur Destructeur;
   /* Destructeur(); */
TypUpsVmMethodeAffecter MethodeAffecter;
   /* Operateur =(P:Nul Ou Objet); */
TypUpsVmMethodeEgal MethodeEgal;
   /* Operateur ==(P:Nul Ou Objet) Retourner Nul Ou Booleen; */
TypUpsVmMethodeDifferent MethodeDifferent;
   /* Operateur !=(P:Nul Ou Objet) Retourner Nul Ou Booleen; */
TypUpsVmMethodeCoherenceEntier MethodeCoherenceEntier;
   /* Contrainte pour un entier; */
TypUpsVmMethodeCoherenceReel MethodeCoherenceReel;
   /* Contrainte pour un reel; */
TypUpsVmMethodeCoherence MethodeCoherence;
   /* Contrainte pour un Objet; */
TypUpsVmMethodeCloner MethodeCloner;
   /* Methode de clonage pour un Objet; */
TypUpsVmMethodeExporter MethodeExporter;
   /* Methode d'exportation pour Objet; */
TypUpsVmMethodeImporter MethodeImporter;
   /* Methode d'importation pour Objet; */
TypUpsVmMethodeAllouerRessource MethodeAllouerRessource;
   /* Methode d'allocation de la ressource pour un Objet; */
TypUpsVmMethodeLibererRessource MethodeLibererRessource;
   /* Methode de liberation de la ressource pour un Objet; */
/*--------------------------------------------------------------*/
/* Pour le dictionnaire de donnees et de traitements.           */
/*--------------------------------------------------------------*/
TypUpsVmMethodeLirePropriete MethodeLirePropriete;
   /* Methode de lecture d'une propriete pour un Objet; */
TypUpsVmMethodeEcrirePropriete MethodeEcrirePropriete;
   /* Methode d'ecriture d'une propriete pour un Objet; */
TypUpsVmMethodeIncrementerDecrementerPropriete MethodeIncrementerDecrementerPropriete;
   /* Methode d'incrementation ou de decrementation d'une propriete pour un Objet; */
TypUpsVmMethodeSupprimerPropriete MethodeSupprimerPropriete;
   /* Methode de suppression d'une propriete pour un Objet; */
TypUpsVmMethodeEnumererProprietes MethodeEnumererProprietes;
   /* Methode d'enumeration des proprietes pour un Objet; */
TypUpsVmMethodeEnumererAppels MethodeEnumererMethodes;
   /* Methode d'enumeration des methodes pour un Objet; */
/*--------------------------------------------------------------*/
/* Pour Up ! Object Management System.                          */
/*--------------------------------------------------------------*/
TypUpsVmUtiliserObjetsChamps MethodeUtiliserObjetsChamps;
   /* Utilise les champs d'un objet pour une transaction; */
TypUpsVmNePlusUtiliserObjetsChamps MethodeNePlusUtiliserObjetsChamps;
   /* N'utilise plus les champs d'un objet pour une transaction; */
} TypUpsVmEnteteMethodes;

/************************************************************************************/
/* Objet : Definition des appels standardises pour les procedures et les fonctions. */
/************************************************************************************/
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmProcedureSansParametre)(TypUpsVmSession *Session);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmProcedureAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsVmFonctionEnumereCourtSansParametre)(TypUpsVmSession *Session);
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsVmFonctionEnumereCourtAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsVmFonctionEnumereLongSansParametre)(TypUpsVmSession *Session);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsVmFonctionEnumereLongAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmLong UpsVmAPI (*TypUpsVmFonctionEntierSansParametre)(TypUpsVmSession *Session);
typedef TypUpsVmLong UpsVmAPI (*TypUpsVmFonctionEntierAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmDouble UpsVmAPI (*TypUpsVmFonctionReelSansParametre)(TypUpsVmSession *Session);
typedef TypUpsVmDouble UpsVmAPI (*TypUpsVmFonctionReelAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmFonctionObjetSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmFonctionObjetAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees UpsPrm);

/****************************************************************/
/* Objet : Definition des appels standardises pour les methodes.*/
/****************************************************************/
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmConstructeurAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsVmMethodeEnumereCourtSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsVmMethodeEnumereCourtAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsVmMethodeEnumereLongSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsVmMethodeEnumereLongAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmLong UpsVmAPI (*TypUpsVmMethodeEntierSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
typedef TypUpsVmLong UpsVmAPI (*TypUpsVmMethodeEntierAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmDouble UpsVmAPI (*TypUpsVmMethodeReelSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
typedef TypUpsVmDouble UpsVmAPI (*TypUpsVmMethodeReelAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeObjetSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseResultat);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsVmMethodeObjetAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees UpsPrm);

typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeComposerObjet)(TypUpsVmSession *, TypUpsVmAdresse *, TypUpsVmAdresse *);
   /* Methode de composition d'un operateur d'un objet. */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmMethodeIncrementerDecrementerObjet)(TypUpsVmSession *, TypUpsVmAdresse *, TypUpsVmAdresse *, TypUpsVmChar *);
   /* Methode d'incrementation ou de decrementation d'un objet. */

/************************************************************************************/
/* Objet : Definition des appels standardises pour les analyseurs.                  */
/************************************************************************************/
typedef enum EnuUpsVmAction UpsVmAPI (*TypUpsVmCorrigerErreur)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleSource, TypUpsVmLong NumeroLigne, TypUpsVmLong NumeroColonne,
   enum EnuUpsVmCorrection Action, TypUpsVmLong Taille, TypUpsVmUnicode *Chaine);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsVmEnvoyerErreur)(TypUpsVmSession *Session, TypUpsVmUnicode *Message, TypUpsVmLong NumeroColonne, TypUpsVmLong NumeroLigne, TypUpsVmUnicode *Source);

typedef struct typupsvtmmodule *(*TypUpsVtmCreerTableModules)(TypUpsVmChar *NomModulePrincipal, TypUpsVtmMachineInterface MachineInterfaceUpsVtm);

/****************************************************************/
typedef struct typupsvtmmodule
/* Objet: Description d'un module faisant partie du processus.  */
/****************************************************************/
{
TypUpsVmChar NomModule[CO_TailleIdf+1];
   /* Nom du module pour trouver sa bibliotheque. */
TypUpsVtmAPIDemarrer DemarrerModule;
   /* Procedure de demarrage du module pour les modules statiques. */
enum EnuUpsVtmLireInterface LireInterface;
   /* Type d'interface demandee. */
} TypUpsVtmModule;

#define UpsVmSetJmp(Registres) setjmp(Registres)
   /* Objet : Renommage de setjmp(). */
extern TypUpsVmShort UpsVmAPI UpsVtmMain(TypUpsVmPointeurDonnees HandleInstance, TypUpsVmShort argc, TypUpsVmChar **argv, TypUpsVmChar **env, 
   TypUpsVmChar *ChaineArguments, TypUpsVtmCreerTableModules CreerTableModules, enum EnuUpsVmModeLancement ModeLancement, 
   TypUpsVmShort IlExisteSegmentPartage, TypUpsVmPointeurDonnees Environnement);
   /* Objet: Point d'entree dans Up ! Virtual Technical Machine. */
extern DllExport TypUpsVmShort UpsVmAPI UpsVtmMainEx(TypUpsVmPointeurDonnees HandleInstance, TypUpsVmShort argc, TypUpsVmChar **argv, TypUpsVmChar **env, 
   TypUpsVmChar *ChaineArguments, TypUpsVtmCreerTableModules CreerTableModules, enum EnuUpsVmModeLancement ModeLancement, 
   TypUpsVmShort IlExisteSegmentPartage, TypUpsVmPointeurDonnees Environnement, TypUpsVtmMachineInterface MachineInterfaceMinimale);
   /* Objet: Point d'entree dans Up ! Virtual Technical Machine. */
extern TypUpsVmShort UpsVmAPI UpsVtmTerminerModules(TypUpsVmPointeurDonnees Environnement);
   /* Objet : Termine les modules declares pour les adaptateurs serveurs. */
extern DllExport TypUpsVmShort UpsVmAPI UpsVtmTerminerModulesEx(TypUpsVmPointeurDonnees Environnement);
   /* Objet : Termine les modules declares pour les adaptateurs serveurs. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
