/*-------------------------------------------------------------------
Fichier     : upscmp.e
Objet       : En-tete du module Up ! Compiler.

Module      : Up ! Compiler
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsCmp)
/*****************************/
#define PasseModuleUpsCmp 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
typedef struct typupscmpdonnees
/* Objet: Interface des donnees de Ups Compiler.                */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
} *TypUpsCmpDonnees;

/****************************************************************/
typedef struct typprmupscmp_1_1
/* Objet : Parametre de DebuterCompilation(EnvoyerErreur:        */
/* Procedure (Message:Caractere, NumeroColonne:Entier,           */
/* NumeroLigne:Entier, NomFichierSource:Caractere)) Retourner    */
/* Booleen;                              					           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* EnvoyerErreur : Fonction. */
} TypPrmUpsCmp_1_1;

/****************************************************************/
typedef struct typprmupscmp_2_1
/* Objet : Parametre de Compiler(NomFichierSource:Caractere,    */
/* Parametres:Caractere) Retourner Booleen;                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichierSource : Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Parametres : Caractere. */
} TypPrmUpsCmp_2_1;

/****************************************************************/
typedef struct typupscmptraitements_1_1_0
/* Objet: Interface des traitements de Ups Compiler.            */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session, TypPrmUpsCmp_1_1 *UpsPrm);
   /* Objet : Fonction DebuterCompilation(EnvoyerErreur:Procedure (Message:Caractere, NumeroColonne:Entier, NumeroLigne:Entier, */
   /* NomFichierSource:Caractere)) Retourner Booleen; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsCmp_2_1 *UpsPrm);
   /* Objet : Fonction Compiler(NomFichierSource:Caractere, Parametres:Caractere) Retourner Booleen; */
TypUpsVmVoid UpsVmAPI (*Trt_3_1)(TypUpsVmSession *Session);
   /* Objet : Procedure TerminerCompilation(); */

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : Fonction DebuterCompilation(EnvoyerErreur:Procedure (Message:Caractere, NumeroColonne:Entier, NumeroLigne:Entier, */
   /* NomFichierSource:Caractere) Retourner Booleen; */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : Fonction Compiler(NomFichierSource:Caractere, Parametres:Caractere) Retourner Booleen; */
TypUpsVmCoAppel CoTrt_3_1;
   /* Objet : Procedure TerminerCompilation(); */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
} *TypUpsCmpTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsCmpTraitements_1_1_0 TypUpsCmpTraitements;

extern TypUpsVtmMachineInterface UpsCmpMachineInterfaceUpsVtm;
   /* Interface avec la machine pour Ups Vtm. */

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsCmpDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Procedure de demarrage de Ups Cmp. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/

